** Change this to the URL of the web folder where your app files are
#DEFINE APP_URL "http://www.brick.cx/lafox_update_your_app/"

** Change this to the name of your real application
#DEFINE APP_EXE_NAME "MyApplicationLib.exe"


LOCAL loSplash as Form

DoSets()
loSplash = CreateSplash()
	DownloadPatches(APP_URL, loSplash)
	ShellExecute(APP_EXE_NAME,"SHOW")  && I am passing a param to the real app to let it know
loSplash.Kill()                        && that is is ok to show itself - (if no param, it quits)
                                       && I do this to force the user to always use my launcher app 

ENDFUNC 


FUNCTION DoSets() as VOID
	SET SAFETY OFF 
	SET TALK OFF 
ENDFUNC 


FUNCTION CreateSplash() as VOID
	LOCAL loSplash, llJustSplash as Boolean 
	STORE .T. TO llJustSplash
	DO FORM splash NAME loSplash WITH llJustSplash
	loSplash.Top = loSplash.Top - 150 && move form up so Messagebox() does not cover it
	DOEVENTS FORCE && let the form show 
	RETURN loSplash
ENDFUNC 


FUNCTION DownloadPatches(tcURL as String, toSplash as Object ) as VOID
	LOCAL dl, loNewFileCollection as Object
	LOCAL lcLocalManifest, lcWebmanifest as String

	lcLocalManifest = SafeFileToStr("manifest.txt")
	lcWebManifest   = GetWebManifest(tcURL)
	
	loNewFileCollection = GetOnlyNewFiles(lcLocalManifest, lcWebManifest)

	IF (loNewFileCollection.Count > 0) AND (MESSAGEBOX("Updates are available, would you like to get them now?",4+48,"Updates Available")= 6)
		IF CheckFiles(loNewFileCollection)
			DownloadNewFiles(loNewFileCollection, tcURL,toSplash)
			STRTOFILE(lcWebManifest,"manifest.txt")
		ENDIF 	
	ENDIF 	
ENDFUNC 


FUNCTION DownloadNewFiles(toNewFileList as Collection, tcURL as string,toSplash as Object ) as Boolean
	LOCAL dl, lcWebFile, lcLocalfile
	  dl = NEWOBJECT("downloader","downloader.vcx")
	  dl.Visible = .T.
	  
	  FOR EACH lcWebFile IN toNewFileList
	  	lcLocalfile = WindowsFileName(lcWebFile)	
	  	ForceDir(lcLocalFile)
	  	dl.DownloadToFile(tcURL+[/]+lcWebFile, lcLocalFile,toSplash)
	  ENDFOR 
ENDFUNC 	


FUNCTION GetWebManifest(tcURL as String) as String
	  LOCAL dl, lcWebManifest

	  dl = NEWOBJECT("downloader","downloader.vcx")

	  TRY 
	    lcWebManifest = dl.downloadtostring(tcURL+"manifest.php")
	  CATCH
	  	** can't connect or similar problem	
	    ** just return an empty file list
	  	lcWebManifest = ""
	  ENDTRY
	  ** if a bad URL, no files, or no connection, returns an empty file list 
	  RETURN lcWebManifest
ENDFUNC 


FUNCTION SafeFileToStr(tcFilename as String) as String
	LOCAL lcResult
	TRY 
		lcResult = FILETOSTR(tcFileName)
	CATCH
		lcResult = []
	ENDTRY
	RETURN lcResult
ENDFUNC 


FUNCTION StrToCollection(tcInputStr as String) as Collection 
	LOCAL loCollection
	loCollection = CREATEOBJECT("Collection")
	=ALINES(laLines, tcInputStr,7)
	FOR EACH lcLine IN laLines
		IF NOT EMPTY(lcLine)
			loCollection.add(lcLine)
		ENDIF 	
	ENDFOR 
	RETURN loCollection 
ENDFUNC 



FUNCTION GetOnlyNewFiles(tcLocalManifest, tcWebManifest as String) as Collection
	EXTERNAL ARRAY loLines
	LOCAL loLines as Collection, lcFileName as String 
	  loLines = StrToCollection(tcWebManifest)

	  FOR i = loLines.Count TO 1 STEP -1
	  	lcLine = loLines(i)
	  	lcFileName = STRTRAN(GETWORDNUM(lcLine,1,[,]),[/],[\])
		loLines.remove(i)
	  	IF (not (lcLine $ tcLocalManifest)) OR (NOT FILE(lcFileName))
	  		** no local file - we need to get the file from the web
	  		** We should add to check file size as well here
			** Strip file date and size - we just need the file name
			loLines.Add(lcFileName)
	  	ENDIF 	
	  ENDFOR 
	RETURN loLines
ENDFUNC 

	
FUNCTION WindowsFileName(tcWebFile as String) as String
	LOCAL lcFile, lcPath
	lcFile = STRTRAN(tcWebFile,[/],[\])
	RETURN ADDBS(SYS(5)+CURDIR())+lcFile
ENDFUNC 


FUNCTION ForceDir(tcFileName as String) as VOID 
	LOCAL lcPath
	lcPath = JUSTPATH(tcFileName)
	TRY 
		MD (lcPath)  && create dir if not exists
	CATCH
		** if dir exists - eat errors
	ENDTRY
ENDFUNC 


FUNCTION CheckFiles(loNewFileCollection as Collection)
*!*		LOCAL lcFile
*!*		FOR EACH lcFile IN loNewFileCollection
*!*			** Add code here if you want to check for a particular new file
*!*			** Return .F. if you want to STOP the update
*!*			IF UPPER(lcFile) = "DATABASEUPDATE.FXP" 
*!*				MESSAGEBOX("Please have a system administrator run the data utility")
*!*				RETURN .F.
*!*			ENDIF 
*!*		ENDFOR 
	RETURN .T.
	** Return .T. = If you want to download new files
	** Return .F. = Cancel the download
ENDFUNC 

