#define WM_USER                   0x0400
#define WM_USER_SHNOTIFY          WM_USER+10
#define SHCNE_RENAMEITEM          0x00000001
#define SHCNE_CREATE              0x00000002
#define SHCNE_DELETE              0x00000004
#define SHCNE_MKDIR               0x00000008
#define SHCNE_RMDIR               0x00000010
#define SHCNE_MEDIAINSERTED       0x00000020
#define SHCNE_MEDIAREMOVED        0x00000040
#define SHCNE_DRIVEREMOVED        0x00000080
#define SHCNE_DRIVEADD            0x00000100
#define SHCNE_NETSHARE            0x00000200
#define SHCNE_NETUNSHARE          0x00000400
#define SHCNE_ATTRIBUTES          0x00000800
#define SHCNE_UPDATEDIR           0x00001000
#define SHCNE_UPDATEITEM          0x00002000
#define SHCNE_SERVERDISCONNECT    0x00004000
#define SHCNE_UPDATEIMAGE         0x00008000
#define SHCNE_DRIVEADDGUI         0x00010000
#define SHCNE_RENAMEFOLDER        0x00020000
#define SHCNE_FREESPACE           0x00040000
 
#define SHCNE_DISKEVENTS          0x0002381F
#define SHCNE_GLOBALEVENTS        0x0C0581E0 // Events that dont match pidls first
#define SHCNE_ALLEVENTS           0x7FFFFFFF
#define SHCNE_INTERRUPT           0x80000000 // The presence of this flag indicates
#define GWL_WNDPROC         -4

#define WM_DEVICECHANGE         0x0219
#define DBT_DEVNODES_CHANGED            0x0007
#define DBT_DEVICEARRIVAL               0x8000  &&// system detected a new device
#define DBT_DEVICEQUERYREMOVE           0x8001  &&// wants to remove, may fail
#define DBT_DEVICEQUERYREMOVEFAILED     0x8002  &&// removal aborted
#define DBT_DEVICEREMOVEPENDING         0x8003  &&// about to remove, still avail.
#define DBT_DEVICEREMOVECOMPLETE        0x8004  &&// device is gone
 
#define DBT_DEVTYP_OEM                  0x00000000  &&// oem-defined device type
#define DBT_DEVTYP_DEVNODE              0x00000001  &&// devnode number
#define DBT_DEVTYP_VOLUME               0x00000002  &&// logical volume
#define DBT_DEVTYP_PORT                 0x00000003  &&// serial, parallel
#define DBT_DEVTYP_NET                  0x00000004  &&// network resource 

PUBLIC nOldProc,oMsgHandler
CLEAR
UNBINDEVENTS(0)
oMsgHandler=NEWOBJECT("MsgHandler")
BindEvent(_vfp.hWnd,WM_DEVICECHANGE,oMsgHandler,"HandleWinMsg")
BindEvent(_vfp.hWnd,WM_USER_SHNOTIFY,oMsgHandler,"HandleWinMsg")
? "Total events:",AEVENTS(lAEvents,1)

PROCEDURE Dump(cStr as String) as Number
      LOCAL num,i
      num=0
      FOR i = 1 TO LEN(cStr)
            num=num+(256^(i-1) ) * ASC(SUBSTR(cStr,i,1))
      ENDFOR
      RETURN INT(num)
ENDPROC
 
DEFINE CLASS MsgHandler as session
      dwShNotify=0
      nOldProc=0
      PROCEDURE init
            DECLARE integer GetWindowLong IN WIN32API ;
                  integer hWnd, ;
                  integer nIndex
            DECLARE integer CallWindowProc IN WIN32API ;
                  integer lpPrevWndFunc, ;
                  integer hWnd,integer Msg,;
                  integer wParam,;
                  integer lParam
            DECLARE integer SHGetPathFromIDList IN shell32 ;
                  integer nItemList,;
                  string @szPath
            DECLARE integer SHChangeNotifyRegister IN shell32 ;
                  integer hWnd, ;
                  integer fSources, ;
                  integer fEvents, ;
                  integer wMsg,;
                  integer cEntries, ;
                  string @ SEntry 
            DECLARE integer SHChangeNotifyDeregister IN shell32 integer
            cSEntry = REPLICATE(CHR(0),8)
            this.nOldProc=GetWindowLong(_screen.HWnd,GWL_WNDPROC)
            this.dwShNotify = SHChangeNotifyRegister(_vfp.hWnd, ;
                  SHCNE_DISKEVENTS,;
                  SHCNE_MEDIAINSERTED + SHCNE_MEDIAREMOVED + SHCNE_DRIVEADD + SHCNE_DRIVEREMOVED,;
                  WM_USER_SHNOTIFY,1,;
                  @cSEntry)
            ? "Notify", THIS.dwShNotify
      ENDPROC
            
      PROCEDURE destroy
            IF this.dwShNotify != 0
                  IF SHChangeNotifyDeregister(this.dwShNotify) > 0
                        ?"Deregister successful"
                  ELSE
                        ?"Deregister ERRORd"
                  ENDIF 
            ENDIF 
	  		UNBINDEVENT(_vfp.hWnd)
	  ENDPROC
	              
      PROCEDURE ShowBHDR(lParam as Integer)
            hdr=SYS(2600,lParam,12)
            size=dump(LEFT(hdr,4))
            num=dump(SUBSTR(hdr,5,4))
            IF num=DBT_DEVTYP_VOLUME
                  unitmask=dump(SUBSTR(SYS(2600,lParam,size),13,4))
                  ??unitmask
                  flags=dump(SUBSTR(SYS(2600,lParam,size),17,2))
                  ??" Flags=",flags
            ENDIF
      ENDPROC
            
      PROCEDURE HandleWinMsg(hWnd as Integer, Msg as Integer, wParam as Integer, lParam as Integer)
            lResult=0
            ?this.name,TRANSFORM(hWnd,"@0x"),TRANSFORM(Msg,"@0x"),TRANSFORM(wParam,"@0x"),TRANSFORM(lParam,"@0x")
            DO CASE 
            CASE msg=WM_DEVICECHANGE
                  DO case
                  CASE wParam=DBT_DEVNODES_CHANGED
                        ?"devnodes changed"
                  CASE wParam=DBT_DEVICEARRIVAL
                        ?"device arrival"
                        this.ShowBHDR(lParam)
                  CASE wParam=DBT_DEVICEREMOVECOMPLETE
                        ?"device remove complete"
                        this.ShowBHDR(lParam)
                  ENDCASE
            CASE msg=WM_USER_SHNOTIFY
                  DO case
                  CASE lParam=SHCNE_DRIVEADD
                        ?"Drive added "
                  CASE lParam=SHCNE_DRIVEREMOVED
                        ?"Drive removed" 
                  CASE lParam=SHCNE_MEDIAINSERTED
                        ?"Media inserted "
                  CASE lParam=SHCNE_MEDIAREMOVED
                        ?"Media removed "
                  ENDCASE 
                  num=Dump(SYS(2600,wParam,4))
                  
                  szPath=SPACE(270)
                  SHGetPathFromIDList(num,@szPath)
                  szPath=LEFT(szPath,AT(CHR(0),szPath)-1)
                  ??" path=",ALLTRIM(szPath)
			lResult=CallWindowProc(this.nOldProc,hWnd,msg,wParam,lParam)
            ENDCASE
	        RETURN lResult
      ENDPROC

ENDDEFINE
