LPARAMETERS tcListID, tcFullName

#INCLUDE qbfc.h
LOCAL loQBSM, loRequest, loCustQuery

CREATE CURSOR Customers (ListID C(20), FullName C(50), Contact C(30), Phone C(20))

* create the session manager which will communicate with QuickBooks
loQBSM = CREATEOBJECT('QBFC1.QBSessionManager')

* open connection with QuickBooks
loQBSM.OpenConnection('VFP QBFC 1.1 Sample Application', 'VFP QBFC 1.1 Sample Application')

* open a session with QuickBooks using the company file which is
* currently open
loQBSM.BeginSession('', qbFileOpenDoNotCare) && 2

* get a message set request object (version 1.1 xml)
loRequestSet = loQBSM.CreateMsgSetRequest(1,1)

* set the on error attribute for the request
loRequestSet.Attributes.OnError = qbContinueOnError && 1

* Build a set of requests - in this case, containing only one request
* Add a request to the request set
loCustomerQuery = loRequestSet.AppendCustomerQueryRq

*SUSPEND

* First Parameter
IF VARTYPE(tcListID) = "C" AND !ISBLANK(tcListID)
	* Note - There doesn't appear to be a way to pull a specific record using the ListID!
	* This code doesn't work.
	loCustomerQuery.ORCustomerListQuery.CustomerListFilter.ORNameFilter.ListIDFilter.Name.SetValue(tcListID)
	loCustomerQuery.ORCustomerListQuery.CustomerListFilter.ORNameFilter.ListIDFilter.MatchCriterion.SetValue(1) && 0 - Starts With, 1 - Contains, 2 - Ends With
ELSE
	* Second Parameter
	IF VARTYPE(tcFullName) = "C" AND !ISBLANK(tcFullName)
		loCustomerQuery.ORCustomerListQuery.CustomerListFilter.ORNameFilter.NameFilter.Name.SetValue(tcFullName)
		loCustomerQuery.ORCustomerListQuery.CustomerListFilter.ORNameFilter.NameFilter.MatchCriterion.SetValue(1) && 0 - Starts With, 1 - Contains, 2 - Ends With
	ELSE
		=MESSAGEBOX("Forgot to specify parameter")
		RETURN
	ENDIF	
ENDIF

* Send the request set to QuickBooks
loResponseSet = loQBSM.DoRequests(loRequestSet)

* Check response status and data

* The response list contains only one response, corresponding to our single request
loCustResp = loResponseSet.ResponseList.GetAt(0)

* Any status code other than `0' should be investigated further
IF (loCustResp.StatusCode # 0)
	MESSAGEBOX("Status: Code = " + ALLTRIM(STR(loCustResp.StatusCode)) + ;
		", Severity = " + loCustResp.StatusSeverity + ;
		", Message = " + loCustResp.StatusMessage)
ENDIF

* loop through the collection of customer ret objects
* 0 based array
FOR lni = 0 TO loCustResp.Detail.Count - 1
	
	* get reference to single customer
	loCust = loCustResp.Detail.GetAt(lni)
	
	lcListID = loCust.ListID.GetValue()
	
	* get the value of the fullname tag
	lcFullName = loCust.FullName.GetValue()
	
	* get the contact information if it exists .. if not avoid errors
	IF VARTYPE(loCust.Contact) = "O"
		lcContact = loCust.Contact.GetValue()
	ELSE
		lcContact = "[not set]"
	ENDIF

	* get the phone number if it exists .. if not avoid errors
	IF VARTYPE(loCust.Phone) = "O"
		lcPhone = loCust.Phone.GetValue()
	ELSE
		lcPhone = "[not set]"
	ENDIF

	* get the value of the Sublevel tag
	lnSubLevel = loCust.SubLevel.GetValue()
	
	* note the projects (sublevel is 1)
	IF lnSubLevel = 1
		lcFullName = '    Project: ' + lcFullName
	ENDIF
	
	* insert into cursor
	INSERT INTO Customers VALUES (lcListID, lcFullName, lcContact, lcPhone)

ENDFOR

RETURN

* Under normal circumstances, the response will contain an ICustomerRet object,
* corresponding to the added customer
loCustomerRet = loResponse.Detail
IF !ISNULL(loCustomerRet)
	* In this case, the ListID is the returned data we chose to retrieve
	MESSAGEBOX("CustomerRet ListID = " + loCustomerRet.ListID.GetValue)
ENDIF

* Relinquish the communication channel with QuickBooks
loQBSM.EndSession
loQBSM.CloseConnection

RETURN

FUNCTION CheckForCustomer
LPARAMETERS tcCustomer

loQBSM = CREATEOBJECT('QBFC1.QBSessionManager')
loQBSM.OpenConnection('VFP QBFC 1.1 Sample Application', 'VFP QBFC 1.1 Sample Application')
loQBSM.BeginSession('', 2)
loRequestSet = loQBSM.CreateMsgSetRequest(1,1)
loRequestSet.Attributes.OnError = 1
loCustomerQuery = loRequestSet.AppendCustomerQueryRq()
loCustomerQuery.ORCustomerListQuery.CustomerListFilter.ORNameFilter.NameFilter.Name.SetValue(tcCustomer)
loCustomerQuery.ORCustomerListQuery.CustomerListFilter.ORNameFilter.NameFilter.MatchCriterion.SetValue(1) && 0 - Starts With, 1 - Contains, 2 - Ends With
loResponseSet = loQBSM.DoRequests(loRequestSet)
loCustomerResp = loResponseSet.ResponseList.GetAt(0)
IF loCustomerResp.StatusCode = 0
	loCustomer = loCustomerResp.Detail.GetAt(0)
	?
	?loCustomer.RefNumber.GetValue()
	?
	RETURN loCustomerResp.Detail.Count > 0 AND ALLTRIM(UPPER(tcCustomer))== ALLTRIM(loCustomer.Name.GetValue())
ELSE
	RETURN .F.
ENDIF
ENDFUNC && CheckForCustomer
