* Code by Stuart Dunkeld and taken from his blog: http://weblogs.foxite.com/stuartdunkeld/archive/2005/09/14/910.aspx

CLEAR

** Example usage: query a remote PC for the startup commands buried in the registry
oWMIConnection = createobject("WMIConnect")
*!*	oWMIConnection.cDomain = "domain"
*!*	oWMIConnection.cUsername = "Username"
*!*	*!*	* Computer can be specified by IP address or DNS name.
*!*	oWMIConnection.cComputer = "TargetComputer" 
*!*	oWMIConnection.cPassword = "ItsASecret"
oWMI = oWMIConnection.GetConnection()
if vartype(oWMI) = "O"
	oCommands = oWMI.ExecQuery("Select * from WIN32_StartupCommand")
	? transform(oCommands.Count) + " startup commands found:"
*!*		FOR EACH oCommand IN oCommands
*!*			? '   '+oCommand.Name
*!*		ENDFOR 
endif

** WMI connection class

define class WMIConnect as relation

	** User/domain settings
	cDomain = ""
	cUserName = ""
	cPassword = ""

	** Target computer. 
	cComputer = "" 

	** WMI settings
	cNameSpace = "root/cimv2"

	* Without this flag, a connection attempt would wait indefinitely.
	* nFlags = 128 && XP or better only..
	nFlags = 0

	* Find your Locale ID here: 
	* http://www.microsoft.com/globaldev/reference/win2k/setup/lcid.mspx
	cLocale = "MS_409" && EN-US

	** Security settings.
	nImpersonationLevel = 3 && wbemImpersonationLevelImpersonate
	nAuthenticationLevel = 0 && wbemAuthenticationLevelDefault

	* If .T., load all privileges before connection.
	lLoadPrivileges = .f.

	procedure GetConnection

		local cUserName, cPassword, lRemote, oWMILocator, ;
			oPrivileges, oWMIServices, nPrivilegeID

		if empty(this.cComputer)
			* Use "." for a local connection
			this.cComputer = "."
		endif

		if this.cComputer = "."
			* Cannot use credentials to connect locally
			* even if they are the ones currently in use.
			cUserName = ""
			cPassword = ""
			lRemote = .f.
		else
			cUserName = iif(not empty(this.cDomain), this.cDomain + "\", "") + this.cUserName
			cPassword = this.cPassword
			lRemote = .t.
		endif

		oWMILocator = createobject("WbemScripting.SWbemLocator")

		if lRemote
			* Apply settings for DCOM:
			oWMILocator.Security_.ImpersonationLevel = this.nImpersonationLevel
			oWMILocator.Security_.AuthenticationLevel = this.nAuthenticationLevel
		else
			* Privileges only need to be applied for on local system
			* but must be requested *before* connection on Windows 9x/NT
			if this.lLoadPrivileges
				for nPrivilegeID = 1 to 27
					oWMILocator.Security_.Privileges.add(nPrivilegeID)
				next
			endif
		endif

		cAuthority = "" && for kerberos, see PSDK

		* Connect as specified...
		oWMIServices = oWMILocator.ConnectServer ;
			(this.cComputer, this.cNameSpace, cUserName, cPassword, ;
			this.cLocale, cAuthority, this.nFlags)
		* ... and return the WMI service object.
		return oWMIServices

	endproc

	procedure error(nError, cMethod, nLine)

		* Sample error code
		* This needs to be tested across versions to make sure 
		* same errors are raised.
		local arrErr[1]
		aerror(arrErr)
		display memory like arrErr

		if nError = 1429 or nError = 1427
			nError = arrErr(7)
		else
			messagebox("Error " + transform(nError) + " has occurred")
			* Oops..
		endif

		do case		
			case nError = 4110
				? "Invalid namespace"
			case nError = 4099
				? "Valid credentials, but not allowed to connect"
			case nError = 5
				? "Invalid credentials"
			case nError = 1722
				? "Remote computer not found" 
		endcase
	endproc

enddefine


