LPARAMETERS tcWhichFunction
LOCAL loClass, lcCmd

SET TALK off
CLEAR

IF tcWhichFunction = '?'
	LOCAL laFunctions[1]
	APROCINFO(laFunctions,FORCEEXT(SYS(16),'PRG'),2)
	FOR i = 1 TO ALEN(laFunctions,1)
		IF LEFT(laFunctions[i,1],7) = "WMIDemo"
			? STRTRAN(laFunctions[i,1],"WMIDemo.","")
		ENDIF 
	ENDFOR 
ELSE 
	IF EMPTY(tcWhichFunction)
		MESSAGEBOX("You must pass a Function to this program!",48,"Incorrect parameter")
	ELSE
		TRY 
			loClass = CREATEOBJECT("WMIDemo")
			lcCmd = 'loClass.'+tcWhichFunction+'()'
			&lcCmd
		CATCH TO oError
			MESSAGEBOX(oError.Message)
*!*				MESSAGEBOX("Error in Function or Function not found. (It may be a hidden function.)"+CHR(13)+" Send ? parameter to see available functions.",48,"No such function")
		ENDTRY 
	ENDIF 
ENDIF 

RETURN 

*******************************************************************************
DEFINE CLASS WMIDemo as Custom 

	lPrintJobRunning = .F.
	cPrinterName = ''

	*******************************************************************************
	FUNCTION ShowCDDrives
	LOCAL loWMI, loCDs

	loWMI = This.IsWMIRunning()
	IF NOT ISNULL(loWMI)
		* Although the Win32_CDROMDrive class structure contains much more information than
		* the fields I've named in this query, the Name,CreationClassname and drive are all
		* I'm looking for here. I can limit my query to just the field(s) I need.
		loCDs = loWMI.ExecQuery('Select Name, CreationClassname, Drive from Win32_CDROMDrive')
		FOR EACH loDrive IN loCDs
			? loDrive.Name
			? loDrive.creationclassname
			? loDrive.drive
		ENDFOR 

		loWMI = NULL
	ENDIF 

	ENDFUNC 
	*******************************************************************************
	FUNCTION ShowFloppyDriveCount
	LOCAL loWMI, loFloppies

	loWMI = This.IsWMIRunning()
	IF NOT ISNULL(loWMI)
		loFloppies = loWMI.ExecQuery('Select * from Win32_FloppyDrive')
		DO CASE 
		CASE loFloppies.Count = 0
		   MESSAGEBOX("This computer does NOT have a floppy drive.")
		CASE loFloppies.Count = 1
		   MESSAGEBOX("This computer has a single floppy drive.")
		OTHERWISE
		   MESSAGEBOX("This computer has "+TRANSFORM(loFloppies.Count)+" floppy drives.")
		ENDCASE 

		loWMI = NULL
	ENDIF 

	ENDFUNC 
	*******************************************************************************
	FUNCTION ShowProcessorCount
	LOCAL loWMI, loProcessorInfo

	loWMI = This.IsWMIRunning()
	IF NOT ISNULL(loWMI)
		loProcessorInfo = loWMI.ExecQuery('Select * from Win32_Processor')
		? loProcessorInfo.Count

		loWMI = NULL
	ENDIF 

	ENDFUNC 
	*******************************************************************************
	FUNCTION ShowProducts
	LOCAL loWMI, loProducts, loProduct

	loWMI = This.IsWMIRunning()
	IF NOT ISNULL(loWMI)
		WAIT WINDOW NOWAIT "This one takes a while. Please wait..."
		* Although the Win32_Product class structure contains much more information than
		* just the name of the product, the name is all I'm looking for here. I can
		* limit my query to just the field(s) I need.
		loProducts = loWMI.ExecQuery('Select Name from Win32_Product')
		FOR EACH loProduct IN loProducts
		   ? loProduct.Name
		ENDFOR 

		loWMI = NULL
		WAIT CLEAR 
	ENDIF 

	ENDFUNC 
	*******************************************************************************
	HIDDEN FUNCTION IsWMIRunning
	*** Check if WMI is running
	LOCAL loWMI

	TRY 
		* The following line will start the service if it's not running and is 
		* set to manual or automatic.
		* It will fail if the service is disabled.
		loWMI	= GETOBJECT('WinMgmts:')
	*	MESSAGEBOX("WMI is running. You may proceed.")
	CATCH
		MESSAGEBOX("WMI isn't running")
		loWMI = NULL
	ENDTRY 	

	RETURN loWMI

	ENDFUNC 
	*******************************************************************************
	FUNCTION PausePrinter
	LOCAL loWMI, lcPrinter, loPrinters, loPrinter, lcQuery
	
	loWMI = This.isWMIRunning()
	IF NOT ISNULL(loWMI)
		lcPrinter = GETPRINTER()
		IF NOT EMPTY(lcPrinter)
			lcQuery = "Select * from Win32_Printer where Caption = '"+lcPrinter+"'"
			loPrinters = loWMI.ExecQuery(lcQuery)
			FOR EACH loPrinter IN loPrinters
				IF loPrinter.Pause() = 0
					MESSAGEBOX(lcPrinter+" has been paused.",64,"Success")
				ELSE
					MESSAGEBOX(lcPrinter+" could not be paused.",48,"Failure")
				ENDIF 
			ENDFOR 
		ENDIF 
	ENDIF 
	
	ENDFUNC 
	*******************************************************************************
	FUNCTION ResumePrinter
	LOCAL loWMI, lcPrinter, loPrinters, loPrinter
	
	loWMI = This.isWMIRunning()
	IF NOT ISNULL(loWMI)
		lcPrinter = GETPRINTER()
		IF NOT EMPTY(lcPrinter)
			loPrinters = loWMI.ExecQuery("Select * from Win32_Printer where Caption = '"+lcPrinter+"'")
			FOR EACH loPrinter IN loPrinters
				IF loPrinter.Resume() = 0
					MESSAGEBOX(lcPrinter+" has been resumed.",64,"Success")
				ELSE
					MESSAGEBOX(lcPrinter+" could not be resumed.",48,"Failure")
				ENDIF 
			ENDFOR 
		ENDIF 
	ENDIF 
	
	ENDFUNC 
	*******************************************************************************
	FUNCTION StopAutoUpdates
	LOCAL loWMI, loServices, loService

	loWMI = This.isWMIRunning()
	IF NOT ISNULL(loWMI)
		loServices = loWMI.ExecQuery("Select * from Win32_Service where Name = 'wuauserv'")
		For Each loService IN loServices
	    	IF loService.StopService() = 0
				MESSAGEBOX("Service stopped.",64,"Success")
			ELSE
				MESSAGEBOX("Service could not be stopped.",48,"Failure")
			ENDIF 
		ENDFOR
	ENDIF 
	
	ENDFUNC 
	*******************************************************************************
	FUNCTION StartAutoUpdates
	LOCAL loWMI, loServices, loService

	loWMI = This.isWMIRunning()
	IF NOT ISNULL(loWMI)
		loServices = loWMI.ExecQuery("Select * from Win32_Service where Caption = 'Automatic Updates'")
		For Each loService IN loServices
	    	IF loService.StartService() = 0
				MESSAGEBOX("Service started.",64,"Success")
			ELSE
				MESSAGEBOX("Service could not be started.",48,"Failure")
			ENDIF 
		ENDFOR
	ENDIF 
	
	ENDFUNC 
	*******************************************************************************
	FUNCTION CatchPrintEvent
	* Provided by Stuart Dunkeld and modified by Barbara Peisch

	* When a new printjob is started, echo the originating pc and page count
	* RELEASE oEventCatcher in the command window to stop.
	LOCAL loEventCatcher, lcQuery, llXit

	loEventCatcher = createobject("eventcatcher",This)

	* __InstanceCreationEvent is a Systems class (Intrinsic Event Class)
	lcQuery = [select * from __InstanceCreationEvent within 1 where TargetInstance ISA 'Win32_PrintJob']
	loEventCatcher.CatchEvents(lcQuery)

	DECLARE integer Sleep IN kernel32 as Sleep integer
	
	llXit = .F.
	SET ESCAPE ON 
	ON ESCAPE llXit = .T.
	DO WHILE NOT llXit
		IF This.lPrintJobRunning
			This.QueryPrintEvent()
		ENDIF 

		DOEVENTS 
		=sleep(500)
	ENDDO 
	ON ESCAPE 

	RETURN
	
	ENDFUNC 
	*******************************************************************************
	HIDDEN FUNCTION QueryPrintEvent
	LOCAL lcStatus, loWMI

	* Note: For simplicity's sake, I'm querying the Win32_PrintJob class again.
	* You may prefer to use the Windows GetPrinter() API (not VFP's GETPRINTER() function)
	* to get a more specific printer status. Doing so is rather complex because it requires 2
	* calls to GetPrinter()--one to get the buffer size for the PRINT_INFO_n buffer and one to
	* populate it. It may also require a call to DocumentProperties() to populate the DevMode
	* structure. If you want to look into this technique see http://support.microsoft.com/kb/140285
	* for examples in VB.
	
	loWMI = This.isWMIRunning()
	IF NOT ISNULL(loWMI)
		loPrintJobs =  loWMI.ExecQuery("Select * from Win32_PrintJob ")
		FOR EACH loPrintJob IN loPrintJobs
			IF NOT INLIST(UPPER(loPrintJob.Status),"OK","UNKNOWN")
				_screen.AlwaysOnTop = .T.
				MESSAGEBOX("There is a problem with your print job."+CHR(13)+"Status: "+loPrintJob.Status)
				_screen.AlwaysOnTop = .F.
				This.lPrintJobRunning = .F.
			ENDIF 
		ENDFOR  
	ENDIF 

	RETURN
	
	ENDFUNC 
ENDDEFINE 

*******************************************************************************
** Event catching class

define class eventcatcher as relation

	oSink = .null.
	oWbemSink = .null.
	oWMI = .null.
	oCaller = .null.

	procedure init(toCaller as Object)

		this.oWMI = getobject("winmgmts:")
		* Create the sink objects and bind them
		this.oWbemSink = createobject("wbemscripting.swbemsink")
		this.oSink = createobject("vfpsink",toCaller)
		eventhandler(this.oWbemSink, this.oSink)

	endproc

	procedure destroy

		if vartype(this.oWbemSink) = "O"
			this.oWbemSink.Cancel()
		endif

	endproc

	procedure CatchEvents
		lparameters cQuery
		* Send the WMI sink not the VFP one.
		* Here is where we use an Asynchronous call
		this.oWMI.ExecNotificationQueryAsync(this.oWbemSink, cQuery)
	endproc

enddefine

** The sink class is easier to manage when decoupled from the eventcatcher class

define class vfpsink as relation
	oCaller = .null.

	implements ISWbemSinkEvents in "WbemScripting.SWbemSink"
	
	FUNCTION Init(toCaller as Object)
		This.oCaller = toCaller
	ENDFUNC 

	procedure ISWbemSinkEvents_OnObjectReady(oObject, oAsyncContext)

		* A print job has been started
		This.oCaller.lPrintJobRunning = .T.
		This.oCaller.cPrinterName = oObject.TargetInstance.Drivername
		? "Originating PC: " + oObject.TargetInstance.HostPrintQueue
		? "Pages: " + transform(oObject.TargetInstance.TotalPages)
	endproc

	procedure ISWbemSinkEvents_OnCompleted(nResult, oErrorObject, oAsyncContext)
	
	procedure ISWbemSinkEvents_OnProgress(nUpperBound, nCurrent, cMessage, oAsyncContext)
	* This procedure doesn't help us. It's never called if the print job can't start.
	* This messagebox is here to prove that it's not being called when we need it.
	MESSAGEBOX("In OnProgress event")
	
	procedure ISWbemSinkEvents_OnObjectPut(oObjectPath, oAsyncContext)

enddefine