LOCAL lnIndex, lcPrinterName, lcPort, lcBinNameBfr, lcBinIdBfr, lnTrayCnt, lnTrayCnt2, lnTrayIndex, lcTrayName, lnTrayID

WAIT WINDOW NOWAIT "Finding printer trays...please wait"

* These constants come from the Windows.h file
#DEFINE DC_BINS       6
#DEFINE DC_BINNAMES   12

DECLARE INTEGER DeviceCapabilities IN winspool.drv;
  STRING pDevice, STRING pPort, INTEGER fwCapability,;
  STRING @pOutput, INTEGER pDevMode

CREATE CURSOR PrinterTrays (TrayName C (25), TrayID I, PrinterPos I)

PUBLIC ARRAY aAvailPrinters[1]
APRINTERS(aAvailPrinters)

* Loop through all of the printers and get tray info.
FOR lnIndex = 1 TO ALEN(aAvailPrinters,1)
	lcPrinterName = aAvailPrinters(lnIndex,1)
	lcPort = ALLTRIM(aAvailPrinters(lnIndex,2))

	lcBinNameBfr = REPLICATE(CHR(0), (DeviceCapabilities(lcPrinterName, lcPort, DC_BINNAMES, 0, 0) * 64))
	lcBinIdBfr = REPLICATE(CHR(0), (DeviceCapabilities(lcPrinterName, lcPort, DC_BINS, 0, 0) * 2))

	lnTrayCnt  = DeviceCapabilities(lcPrinterName, lcPort, DC_BINNAMES, @lcBinNameBfr, 0)
	lnTrayCnt2 = DeviceCapabilities(lcPrinterName, lcPort, DC_BINS, @lcBinIdBfr, 0)

	IF lnTrayCnt > 0
		IF lnTrayCnt <> lnTrayCnt2
			MESSAGEBOX("Unable to match IDs to Tray Names for Printer "+aAvailprinters[lnIndex,1],48,'Problem with printer trays')
		ELSE 
			* Each string buffer is 24 characters long, terminated with a NULL / chr(0)
			* and contains the name of a paper bin
			FOR lnTrayIndex = 1 TO lnTrayCnt
				lcTrayName = SUBSTR(lcBinNameBfr, (lnTrayIndex-1)*24+1, 24) + CHR(0)
				lcTrayName = SUBSTR(lcTrayName, 1, AT(CHR(0), lcTrayName)-1)
				lnTrayId = CTOBIN(SUBSTR(lcBinIdBfr, (lnTrayIndex*2)-1, 2),'2sr')
				INSERT INTO PrinterTrays (PrinterPos,TrayName,TrayID) VALUES (lnIndex,lcTrayName,lnTrayId)
			ENDFOR
		ENDIF && lnTrayCnt <> lnTrayCnt2
	ENDIF && lnTrayCnt <> 0
ENDFOR

WAIT CLEAR 
