*** Simplified bus objects to avoid dependence on ww stuff <g>

*** Load dependencies
DO Rss2Feed
SET PROCEDURE TO rssBus additive
DO PATH WITH "DATA"

#IF .F.
o = CREATEOBJECT("rssChannel")
o.GetChannelSummary()
 
BROWSE
RETURN
#ENDIF


DEFINE CLASS RssItem as Custom

************************************************************************
* RssItem :: SaveFeed
****************************************
***  Function: Saves the items of a feed in the data file
***    Assume:
***      Pass: Instance of a loaded Rss2Feed object
***    Return:
************************************************************************
FUNCTION SaveFeed(loRss,lcChannelPk,llMarkAsRead)
LOCAL Item

IF !THIS.Open()
   RETURN .F.
ENDIF

FOR EACH Item IN loRss.oItems
   LOCATE FOR Title = Item.Title AND ChannelPk = lcChannelPk AND PubDate = Item.PubDate
   
   *** If it already exists leave it alone
   IF FOUND()
      LOOP
   ENDIF
   
   *** Otherwise add it to the table
   APPEND BLANK
   replace pk WITH SYS(2015), ;
           ChannelPk WITH lcChannelPk, ;
           Descript WITH Item.Description,;
           Title WITH Item.Title,;
           pubDate WITH Item.pubDate,;
           Author WITH Item.Author,;
           Url WITH Item.Url,;
           CommentUrl WITH Item.CommentUrl
           
   IF EMPTY(pubDate)
      REPLACE pubDate with DATE()
   ENDIF
ENDFOR

IF llMarkAsRead
   REPLACE ALL Read WITH .T. for ChannelPk = lcChannelPk
ENDIF

RETURN .T.
ENDFUNC
*  RssItem :: SaveFeed

************************************************************************
* RssItem :: DeleteFeedItems
****************************************
***  Function:
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION DeleteFeedItems(lcChannelPk)

IF !THIS.Open()
   RETURN .f.
ENDIF

DELETE FOR ChannelPk == lcChannelPk

RETURN .T.
ENDFUNC
*  RssItem :: DeleteFeedItems


************************************************************************
* RssItem :: LoadRSSFromCursor
****************************************
***  Function:
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION LoadRSSItemsFromCursor(lcChannelPk,lnCount)
LOCAL loRss, loChannel, Item

IF EMPTY(lnCount)
   lnCount = 50
ENDIF

SELECT * FROM rssItems ;
   WHERE ChannelPk = lcChannelPk ;
   ORDER BY pubDate DESC ;
   TOP (lnCount) ;
   INTO CURSOR TQuery

loRss = CREATEOBJECT("rss2Feed")

SCAN
   Item = loRss.GetNewRssItem()
   Item.Title = Tquery.Title
   Item.Description = TQuery.Descript
   Item.Url = Tquery.Url
   Item.CommentUrl = Tquery.CommentUrl
   Item.pubDate = Tquery.pubDate
   Item.Author = Tquery.Author
   Item.Pk = Tquery.Pk
   
   loRss.oItems.Add(Item)
ENDSCAN

SELECT * from rssChannels ;
   WHERE Pk = lcChannelPk ;
   INTO CURSOR TQuery

loChannel = loRss.GetNewChannel()
loChannel.Link = Tquery.HtmlUrl
loChannel.rssUrl = Tquery.rssUrl
loChannel.title = Tquery.Title
loChannel.description = Tquery.Title 

loRss.oChannelInfo = loChannel

RETURN loRss
ENDFUNC
*  RssItem :: LoadRSSFromCursor


************************************************************************
* rssItem :: Open
****************************************
***  Function: 
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION Open()

IF !USED("rssItems")
   USE rssItems IN 0
ENDIF

SELECT rssItems
RETURN

ENDDEFINE


DEFINE CLASS RssChannel as Custom

************************************************************************
* rssChannel :: GetChannel
****************************************
***  Function:
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION GetChannel(lcPk)

IF !this.Open()
   RETURN .F.
ENDIF

LOCATE FOR PK = lcPK
IF !FOUND()
   RETURN .F.
ENDIF

RETURN .T.
ENDFUNC
*  rssChannel :: GetChannel

************************************************************************
* rssChannel :: GetChannels
****************************************
***  Function:
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION GetChannels()

IF !This.Open()
   RETURN -1
ENDIF

SELECT * from rssChannels ;
   ORDER BY Title ;
   INTO CURSOR TChannels 
   
RETURN RECCOUNT()
ENDFUNC
*  rssChannel :: GetChannels

************************************************************************
* rssChannel :: GetChannelSummary
****************************************
***  Function: Returns channels with detail on new items
***            as a cursor in TChannels cursor
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION GetChannelSummary()

IF !THIS.Open()
   RETURN -1
ENDIF

SELECT *,10000 as ItemCount, 10000 as UnreadCount from rssChannels;
  ORDER BY title ;
  INTO CURSOR TChannels READWRITE
  
SCAN
   SELECT COUNT(*) FROM rssItems WHERE ChannelPk = Tchannels.PK ;
      INTO ARRAY laResult
   SELECT COUNT(*)  FROM rssItems WHERE ChannelPk = Tchannels.PK AND !Read ;
      INTO ARRAY laResult2

    replace ItemCount WITH laResult[1], UnreadCount WITH laResult2[1]
ENDSCAN
   
return RECCOUNT()
ENDFUNC
*  rssChannel :: GetChannelSummary


************************************************************************
* rssChannel :: AddChannel
****************************************
***  Function:
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION AddChannel(loRss) as Boolean 

IF !this.Open()
   RETURN .f.
ENDIF

APPEND BLANK
REPLACE PK WITH SYS(2015) 
IF VARTYPE(loRss) = "O"
   Replace Title WITH loRss.oChannelInfo.Title,;
           HtmlUrl WITH loRss.oChannelInfo.Link,; 
           RssUrl WITH loRss.oChannelInfo.RssUrl,;
           descript WITH loRss.oChannelInfo.Description
ENDIF

RETURN .t.

************************************************************************
* RssChannel :: DeleteChannel
****************************************
***  Function: Deletes an individual Feed
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION DeleteChannel(lcPk) 

IF !this.Open()
   RETURN .f.
ENDIF

LOCATE FOR PK == lcPK
IF !FOUND()
   RETURN .F.
ENDIF

loItem = CREATEOBJECT("RssItem")

IF !loItem.DeleteFeedItems(lcPk)
   RETURN .F.
ENDIF

THIS.Open()
DELETE

RETURN .T.
ENDFUNC


************************************************************************
* rssChannel :: Open
****************************************
***  Function:
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION Open()

IF !USED("rssChannels")
   USE rssChannels IN 0
ENDIF

SELECT rssChannels
RETURN

ENDDEFINE

