
SET PROCEDURE TO wwResponse ADDITIVE
#INCLUDE wconnect.h

**************************************************
*-- Class:        wwResponseString (d:\wwapps\wc3\classes\wcframework.vcx)
*-- ParentClass:  wwResponse
DEFINE CLASS wwResponseString AS WWC_RESPONSE

   *-- String constant that holds the cumulative output
   coutput = ""

   *-- File name used if output is larger than a given size
   PROTECTED cfilename
   cfilename = ""

   *-- Internal property used to tell whether output is temporily sent to file for better performance
   PROTECTED ldumptofile
   ldumptofile = .F.

   *-- Name of HTML file when file dumping occurs
   PROTECTED chtmlfilename
   chtmlfilename = ""
   
   *-- wwHTMLFile object that's used to dump output to file when the buffer gets too big
   PROTECTED ohtmlfile
   ohtmlfile = .NULL.

   *-- Size of the string buffer before dumping to file. If the buffer reaches this size the output is dumped to a temporary disk file
   nbuffersize = 10000


   *-- Returns the cumulative HTML output and clears the output
   PROCEDURE getoutput(llNoClear)
   ************************************************************************
   * wwResponseString :: GetOutput
   ***************************
   ***  Function: Returns the HTML output string previously built.
   ***            Clears the output buffer and file unless llNoClear is set!!!
   ***      Pass: nothing
   ***    Return: output string
   ************************************************************************
   LOCAL lcFile, lcOutput

   IF THIS.ldumptofile
      *** Destroy the HTML file so we can read it
      THIS.ohtmlfile.DESTROY()
      THIS.ohtmlfile=.NULL.
      THIS.ldumptofile=.F.

      lcOutput=File2Var(THIS.chtmlfilename)
      ERASE (THIS.chtmlfilename)

      IF llNoClear
         THIS.coutput=lcOutput
      ELSE
         THIS.cOutput = ""
      ENDIF

      RETURN lcOutput
   ENDIF

   IF llNoClear
      RETURN THIS.coutput
   ENDIF

   lcOutput = THIS.cOutput   
   THIS.cOutput = ""

   RETURN lcOutput


   *-- Gets the current HTML output, but leaves the output intact (not implemented when running with lfile overflow output enabled)
   PROCEDURE getoutputnoclear
   ************************************************************************
   * wwResponseString :: GetOutputNoClear
   **********************************
   ***  Function: Returns the HTML output string previously built.
   ***            Leaves the existing buffer intact.
   ***      Pass: nothing
   ***    Return: output string
   ************************************************************************
   RETURN THIS.Getoutput(.T.)

   PROCEDURE WRITE
   ************************************************************************
   * wwResponseString :: Write
   *********************************
   ***  Function: Adds text to the output string
   ****   Assume: No error checking for speed!
   ***            Any changes here should also be made in Send()
   ***      Pass: tcText      - Text to output
   ***            tlNoOutput  - Flag to send to file or return string
   ***    Return: "" or tcText if tlNoOutput=.T.
   ************************************************************************
   LPARAMETERS tcText,tlNoOutput

   IF tlNoOutput OR THIS.lNoOutput
      RETURN tcText
   ENDIF

   *** Going to file
   IF THIS.ldumptofile
      *** Just dump to file at this point - file is already open
      THIS.ohtmlfile.FastWrite(@tcText)
   ELSE
      IF LEN(THIS.coutput) < THIS.nbuffersize
         *** Plain output to text buffer
         THIS.coutput=THIS.coutput+tcText
      ELSE
         *** First time file output
         *** Set flag - all output now goes to file
         THIS.ldumptofile=.T.

         *** Create HTML file object
         THIS.ohtmlfile=CREATE([WWC_RESPONSEFILE],SYS(2023) + "\" + SYS(2015) + TRIM(TRANS(RAND() * 1000,'999' )) + ".tmp")
         
         THIS.chtmlfilename=THIS.ohtmlfile.cfilename

         *** Dump the existing buffer and add the currently
         *** passed text
         THIS.ohtmlfile.FastWrite(THIS.coutput+tcText)
      ENDIF
   ENDIF

   RETURN ""
   * Write


   *-- Sends output to file. Lowest Level Method. Same as Write()
   PROCEDURE SEND
   LPARAMETERS tcText,tlNoOutput
   RETURN THIS.Write(@tcText,tlNoOutput)


   PROCEDURE FastWrite
   ************************************************************************
   * wwResponseString :: FastWrite
   *********************************
   ***  Function: Adds text to the output string
   ****   Assume: No error checking for speed!
   ***      Pass: tcText      - Text to output
   ***    Return: nothing
   ************************************************************************
   LPARAMETERS tcText, tlNoOutput

   IF THIS.ldumptofile
      THIS.ohtmlfile.FastWrite(@tcText)
   ELSE
      IF LEN(THIS.coutput) < THIS.nbuffersize
         THIS.coutput=THIS.coutput+tcText
      ELSE
         *** Force to file
         THIS.WRITE(@tcText)
      ENDIF
   ENDIF
   RETURN ""
   * FastWrite

   FUNCTION FastSend
   LPARAMETERS tcText, tlNoOutput
   RETURN THIS.FastWrite(@tcText,tlNoOutput)
   ENDFUNC

   
   PROCEDURE CLEAR
   ************************************************************************
   * wwResponseString :: Rewind
   *********************************
   ***  Function: Resets the output property to "". If file output was
   ***            dumped, release and erase the file.
   ************************************************************************

   *** Must delete the temp file if we overflowed
   IF THIS.ldumptofile
      THIS.ohtmlfile.DESTROY()
      THIS.ohtmlfile=.NULL.
      IF !EMPTY(THIS.chtmlfilename)
         ERASE (THIS.chtmlfilename)
      ENDIF
   ENDIF

   THIS.ldumptofile=.F.
   THIS.ohtmlfile=.NULL.
   THIS.coutput=""
   ENDPROC

   PROCEDURE Rewind
   THIS.CLEAR()
   ENDPROC

   PROCEDURE DESTROY
   ************************************************************************
   * wwResponseString :: Destroy
   *********************************
   ***  Function: Destructor: Simply Override wwHTML.
   ************************************************************************

   *** Must delete the temp file if we overflowed
   IF THIS.ldumptofile
      IF !ISNULL(THIS.ohtmlfile)
         THIS.ohtmlfile.DESTROY()
      ENDIF
      ERASE (THIS.chtmlfilename)
   ENDIF
   ENDPROC

   FUNCTION INIT(lcReserved)
   ENDFUNC

ENDDEFINE
*
*-- EndDefine: wwResponseString



**************************************************


**************************************************
*-- Class:        wwResponseStringNoBuffer (d:\wwapps\wc3\classes\wcframework.vcx)
*-- ParentClass:  wwResponse
*-- BaseClass:    custom
*-- Time Stamp:   09/08/99 02:13:01 PM
DEFINE CLASS wwResponseStringNoBuffer AS WWC_RESPONSE

   *-- String constant that holds the cumulative output
   coutput = ""
   
   *-- Returns the cumulative HTML output and clears the output
   PROCEDURE getoutput(llNoClear)
   ************************************************************************
   * wwResponseString :: GetOutput
   ***************************
   ***  Function: Returns the HTML output string previously built.
   ***            Clears the output buffer unless llNoClear is set
   ***      Pass: nothing
   ***    Return: output string
   ************************************************************************
   LOCAL lcFile, lcOutput
   IF llNoClear
      RETURN THIS.coutput
   ENDIF
   lcOutput = THIS.cOutput
   THIS.cOutput = ""
   RETURN lcOutput


   *-- Gets the current HTML output, but leaves the output intact (not implemented when running with lfile overflow output enabled)
   PROCEDURE getoutputnoclear
   ************************************************************************
   * wwResponseString :: GetOutputNoClear
   **********************************
   ***  Function: Returns the HTML output string previously built.
   ***            Leaves the existing buffer intact.
   ***      Pass: nothing
   ***    Return: output string
   ************************************************************************
   LOCAL lcFile
   RETURN THIS.coutput


   *-- Sends output to file. Lowest Level Method. Same as Send()
   PROCEDURE WRITE
   ************************************************************************
   * wwResponseString :: Write
   *********************************
   ***  Function: Adds text to the output string
   ****   Assume: No error checking for speed!
   ***            Any changes here should also be made in Send()
   ***      Pass: tcText      - Text to output
   ***            tlNoOutput  - Flag to send to file or return string
   ***    Return: "" or tcText if tlNoOutput=.T.
   ************************************************************************
   LPARAMETERS tcText,tlNoOutput
   IF tlNoOutput OR THIS.lNoOutput
      RETURN tcText
   ENDIF
   THIS.coutput = THIS.coutput + tcText
   RETURN ""
   * Write

   *-- Backwards compatibility only
   PROCEDURE SEND
   LPARAMETERS tcText,tlNoOutput
   RETURN THIS.Write(@tcText,tlNoOutput)
   * Send

   *-- Sends output to file without checking for string output
   PROCEDURE FastWrite
   ************************************************************************
   * wwResponseString :: FastWrite
   *********************************
   ***  Function: Adds text to the output string
   ****   Assume: No error checking for speed!
   ***      Pass: tcText      - Text to output
   ***    Return: nothing
   ************************************************************************
   LPARAMETERS tcText, tlNoOutput
   THIS.coutput=THIS.coutput+tcText
   RETURN ""
   ENDPROC


   PROCEDURE Rewind
   THIS.CLEAR()
   ENDPROC

   *-- Resets output
   PROCEDURE CLEAR
   ************************************************************************
   * wwResponseString :: Rewind
   *********************************
   ***  Function: Resets the output property to "". If file output was
   ***            dumped, release and erase the file.
   ************************************************************************
   THIS.coutput=""
   ENDPROC

   FUNCTION INIT(lcReserved)
   ENDFUNC
ENDDEFINE
*
*-- EndDefine: wwResponseStringNoBuffer
**************************************************
