*************************************************************************
*PROCEDURE wwStore
******************
***  Function: Processes incoming Web Requests for wwStore
***            requests. This function is called from the wwServer 
***            process.
***      Pass: loServer -   wwServer object reference
*************************************************************************
LPARAMETER loServer
LOCAL loProcess

*** Includes wconnect.h 
#INCLUDE WWSTORE.H

loProcess=CREATE("wwStore",loServer)

*** Use the defined flag to show Request Data
loProcess.lShowRequestData = loServer.oConfig.lShowRequestData

IF VARTYPE(loProcess)#"O"
   *** All we can do is return...
   WAIT WINDOW NOWAIT "Unable to create Process object..."
   RETURN .F.
ENDIF

*** Call the Process Method that handles the request
loProcess.Process()

RETURN

#DEFINE ADMINFOOTER [<hr><img src="..\images\wcpower.gif" align="left" hspace=3><font size="1">] + "[" + [<a href="default.htm">Admin Page</a>] + "]"


*************************************************************
DEFINE CLASS wwStore AS WWC_PROCESS
*************************************************************

nResultMode = 0  && 0 - HTML   2 - XML

*** Internally used properties for persistance
cID = ""
cNextMethod = ""

*********************************************************************
* Function wwStore :: Process
************************************
*** If you need to hook up generic functionality that occurs on
*** every hit, implement this method then call DoDefault() to
*** get the default Request Processing functionality. See docs
*** for more info on how to customize wwProcess::Process behavior.
*********************************************************************
FUNCTION Process
PRIVATE Request, Response, Config

Request = THIS.oRequest
Response = THIS.oResponse
Config = THIS.oServer.oConfig.owwStore
Response.cStyleSheet = Config.cVirtualPath + "wwstore.css"

THIS.InitSession(Config.cCookiename,3600,.t.)

*** Support XML retrieval of data on select request
THIS.nResultMode = IIF(Request.QueryString("Display") = "XML",2,0)

DODEFAULT()

RETURN .T.
ENDFUNC


************************************************************************
* wwStore :: Default
*********************************
***  Function: The store's homepage. Not much happening here other than
***            trying to reattach to the customer's profile.
***            The template page performs banner operations and
***            displaying the category listing using the GetBanner and
***            CategoryList methods of this class.
************************************************************************
FUNCTION Default
PRIVATE pcWelcome
LOCAL oCustomer

oCustomer = CREATE([WWS_CLASS_CUSTOMER])
#IF WWSTORE_USE_SQL_TABLES
oCustomer.SetSQLObject(Server.owwStoreSQL)
#ENDIF

*** See if we can reattach to our profile/customer
IF oCustomer.FindByUserID(Session.cSessionId)
   Session.SetSessionVar("CustomerPK",TRANS(oCustomer.oData.pk))
   pcWelcome = "<b>Welcome back, " + TRIM(oCustomer.oData.FirstName) + ".</b><p>"

   *** Preset Foreign or US/Can status in session for shopping cart
   IF !INLIST(oCustomer.oData.CountryId,"US","CA")
      Session.SetSessionVar("Foreign","True")
   ENDIF         
ELSE
   pcWelcome = ""
   Session.TimeoutSessions()
ENDIF   

Session.SetSessionVar("CookiesOn","True")

Response.ExpandTemplate( Config.cHTMLPagePath + "default.wws" )
RETURN 
ENDFUNC
* wwStore :: Default

************************************************************************
* wwStore :: CookieWarning
****************************************
***  Function: This method is called from the ShoppingCart 
***            page if the CookiesOn session var doesn't exist!
************************************************************************
FUNCTION CookieWarning

THIS.ErrorMsg("This site requires HTTP Cookies",;
              "If you try to connect to this site without cookies " + ;
              "you cannot add items to the shopping cart. " + ;
              "Please check your HTTP Cookie settings in your browser and enable " + ;
              "cookies.<p>" + CRLF + CRLF +;
              "Note: We store only a user id in a single cookie so that we can track you "+;
              "through our online store. This cookie can also be used to re-attach to your " + ;
              "customer information when you return to the store.<p>" + CRLF + CRLF +;
              [<a href="default.wws">Return to store home page</a> after enabling cookies.])

ENDFUNC
*  wwStore :: CookieWarning

************************************************************************
* wwStore :: ItemList
*********************************
***  Function:
***    Assume:
************************************************************************
FUNCTION ItemList
LOCAL loBanner, loSC, loItem
PRIVATE pcCategory, pcBannerText

*** Add Cookie Check session var - in case people jump directly
*** to the list page as their first page
Session.SetSessionVar("CookiesOn","True")

pcCategory = Request.QueryString("Category")

loItem = Create([WWS_CLASS_ITEM])

#IF WWSTORE_USE_SQL_TABLES
loItem.SetSQLObject(Server.owwStoreSQL)
#ENDIF

loItem.cSQLCursor = "TItemList"

*** Get only Web items
IF loItem.nDataMode = 0
   loItem.GetCategoryList(pcCategory,"sku,descript,price,stock","!noweb")
ELSE
   loItem.GetCategoryList(pcCategory,"sku,descript,price,stock","noweb=0")
   IF loItem.lError
      THIS.ErrorMsg(loItem.cErrorMsg,loItem.oSQL.cSQL)
      RETURN
   ENDIF
ENDIF

*** Handle XML Result
IF THIS.nResultMode = 2
   THIS.ReturnCursorXML("items","item")
   RETURN
ENDIF

*** Reformat the cursor for display with showcursor
SELECT PADR([<a href="item.wws?sku=] + TRIM(sku) + [">] + ;
       TRIM(descript) + [</a>],100) as Description,Price,;
       PADR([<a href="additem.wws?sku=] + TRIM(sku) + [&qty=1">] + ; 
       [Add</a>],60) as Buy ;
   FROM TItemList ;
   INTO Cursor TItemList2

LOCAL loSc as wwWebStoreShowCursor
loSC = CREATE("wwWebStoreShowCursor")

IF RECCOUNT() > 15
   loSC.nPage_ItemsPerPage=15
   loSC.cPage_PageURL="ItemList.wws?Category=" + pcCategory + "&"
ENDIF

loSC.ShowCursor()
pcItemList = loSC.GetOutput()

USE IN TITEMLIST
USE IN TITEMLIST2

Response.ExpandTemplate( Request.GetPhysicalPath() )

ENDFUNC
* wwStore :: ItemList

************************************************************************
* wwStore :: Search
*********************************
***  Function:
***    Assume:
************************************************************************
FUNCTION Search
PRIVATE loItem, pcCategory,  pcItemList
LOCAL lcSearch, lcFilter

lcSearch = lower(Request.Form("Search"))
IF EMPTY(lcSearch)
   lcSearch = lower(Request.QueryString("Search"))
ENDIF

lcFilter = Session.GetSessionVar("SearchFilter")

IF EMPTY(lcSearch) AND EMPTY(lcFilter)
   THIS.ErrorMsg("No search parameters provided...")
   RETURN
ENDIF

loItem = Create([WWS_CLASS_ITEM])
#IF WWSTORE_USE_SQL_TABLES
loItem.SetSQLObject(Server.owwStoreSQL)
#ENDIF
loItem.cSQLCursor = "Tquery"

IF !EMPTY(lcSearch) OR EMPTY(lcFilter)
   IF loItem.nDataMode = 0
      lcFilter = '[' + lcSearch + '] $ lower(descript) OR [' + lcSearch + '] $ lower(ldescript) '
   ELSE
      lcFilter =  [ CHARINDEX('] + lcSearch + [',LOWER(cast(descript as varchar)) ) > 0 OR CHARINDEX('] + lcSearch + [',lower(cast(ldescript as varchar))) > 0 ] 
   ENDIF
ENDIF

*** Get a category list for all cats and add the search filter
loItem.GetCategoryList("","sku,descript,price",lcFilter)

*** Handle XML Result
IF THIS.nResultMode = 2
   THIS.ReturnCursorXML("items","item")
   RETURN
ENDIF

*** Reformat the cursor for display with showcursor
SELECT PADR([<a href="item.wws?sku=] + TRIM(sku) + [">] + ;
       TRIM(descript) + [</a>],100) as Description,Price,;
       PADR([<a href="additem.wws?sku=] + TRIM(sku) + [&qty=1">] + ; 
       [Add</a>],50) as Buy ;
   FROM TQuery ;
   INTO Cursor TQuery2

loSC = CREATE("wwWebStoreShowCursor")

IF RECCOUNT() > 15
   loSC.nPage_ItemsPerPage = 15
   loSC.cPage_PageUrl = "search.wws?"
   Session.SetSessionVar("SearchFilter",lcFilter)
ELSE
   Session.SetSessionVar("SearchFilter","")
ENDIF

loSC.ShowCursor()
pcItemList = loSC.GetOutput()

pcCategory = "Search Results"

Response.ExpandTemplate( Config.cHTMLPagePath + "itemlist.wws" )

ENDFUNC
* wwStore :: Search



************************************************************************
* wwStore :: Item
*********************************
***  Function: Displays an item 
************************************************************************
FUNCTION Item
PRIVATE loItem,oItem, pcSKU

*** Add Cookie Check session var - in case people jump directly
*** to an item display page as their first page
Session.SetSessionVar("CookiesOn","True")

*** Create an Item object
loItem = CREATE([WWS_CLASS_ITEM])
#IF WWSTORE_USE_SQL_TABLES
loItem.SetSQLObject(Server.owwStoreSQL)
#ENDIF

pcSKU = UPPER(Request.QueryString("Sku"))

*** Try to retrieve the requested item by sku
IF EMPTY(pcSKU) OR ;
   !loItem.GetItemBySku(pcSku)
   THIS.ErrorMsg("Invalid Item","Invalid SKU. This item is unavailable at this time")
   RETURN
ENDIF

*** Assign to a PRIVATE variable
oItem = loItem.oData

*** Allow redirection if specified for an obsolete item
IF THIS.nResultMode # 2 AND !EMPTY(oItem.Redirect)
   Response.Redirect( TRIM(oItem.Redirect) )
   RETURN
ENDIF

*** Do we return XML?
IF THIS.nResultMode = 2
  THIS.ReturnObjectXML(oItem,,,",regtext,regpass,saveemail")
  RETURN
ENDIF

*** Render the external HTML template
Response.ExpandTemplate( Request.GetPhysicalPath() )
ENDFUNC
* wwStore :: Item


************************************************************************
* wwStore :: AddItem
*********************************
***  Function:
***    Assume:
************************************************************************
FUNCTION AddItem

Session.SetSessionVar("CookiesOn","True")

lcSKU = UPPER(Request.QueryString("Sku"))
IF EMPTY(lcSKU)
   THIS.ErrorMsg("Invalid Item","Invalid SKU. This item is unavailable at this time")
   RETURN
ENDIF

lnQty = VAL(Request.QueryString("qty"))
IF lnQty = 0
	lnQty = VAL(Request.Form("Qty"))
ENDIF
IF lnQty = 0
   lnQty = 1
ENDIF

IF lnQty < 0
   THIS.ShoppingCart("You can't subtract items from your order at this time. Please remove the item, then add it back.")
   RETURN
ENDIF   
IF lnQty = 0
   THIS.ShoppingCart()
   RETURN
ENDIF   

*** Retrieve a temporary Invoice PK either by creating
*** a new PK or retrieving it from the session
lcInvPK = Session.GetSessionVar("InvoicePK")
IF EMPTY(lcInvPK)
   loInv = CREATE([WWS_CLASS_INVOICE])
   #IF WWSTORE_USE_SQL_TABLES
   loInv.SetSQLObject(Server.owwStoreSQL)
   #ENDIF
   
   lnInvPK = loInv.CreateNewId()
   Session.SetSessionVar("InvoicePK",TRANS(lnInvPK))
ELSE
   lnInvPK = VAL(lcInvPK)
ENDIF

*** Item is Ok - now lets create a temporary lineitem basket
loLineItems = CREATE([WWS_CLASS_TLINEITEMS])

#IF WWSTORE_USE_SQL_TABLES
   loLineItems.SetSQLObject(Server.owwStoreSQL)
#ENDIF

IF !loLineItems.New()
   THIS.ErrorMsg("Unable to add lineitem",loLineItems.cErrorMsg)
   RETURN
ENDIF

*** And add the item to it... Generic Routine
*** Last parm 3: Add items as separate items for each sku
loItem = loLineItems.AddItem(lcSku,lnInvPk,lnQty,3)

IF ISNULL(loItem)
   THIS.ErrorMsg("Can't add item to cart",loLineItems.cErrorMsg)
   RETURN
ENDIF

*** Generic Type handler - reads all vars with a type prefix
*** and adds value to the XML properties field
*** adds extra text with the name of the 'property' minus the type prefix
*** Multiple values go on separate lines.
*** Example:  showAttendee -  Var: showAttendee, value: Rick Strahl, ExtraText: Attendee: Rick Strahl
IF !EMPTY(loItem.oData.Type)
   DIMENSION laVars[1,2]
   lnItems = Request.aFormVars(@laVars,loItem.oData.Type)
   FOR x=1 TO lnItems
       loItem.SetProperty(laVars[x,1],laVars[x,2])
       loItem.oData.ExtraText =  loItem.oData.ExtraText + ;
                                 "<br>" + STRTRANC(laVars[x,1],TRIM(loItem.oData.Type),"") + ": " + laVars[x,2]
   ENDFOR
ENDIF

IF ISNULL(loItem)
   THIS.ErrorMsg("Unable to add item to shopping cart",loLineItems.cErrorMsg)
   RETURN
ENDIF
   
*** Must save it to disk manually!
loItem.Save()

*** Redisplay the Shopping Cart
Response.Redirect("ShoppingCart.wws")
* THIS.ShoppingCart()
ENDFUNC
* wwStore :: AddItem


************************************************************************
* wwStore :: ShoppingCart
*********************************
***  Function: Displays the current contents of the shopping
***            cart.
***    Assume:
************************************************************************
FUNCTION ShoppingCart
PARAMETER pcErrorMsg
PRIVATE pcShoppingCart, plNoItems
LOCAL x, lcButton, lcForeign, lcShipDisks, lnInvPk, loInv, ;
      oLineItems, loRow, lcSkuQty

*** Make sure Cookies are on before proceeding!!!
IF EMPTY(THIS.oSession.GetSessionVar("CookiesOn")) 
   THIS.CookieWarning()
   RETURN
ENDIF

IF VARTYPE(pcErrorMsg) # "C"
   pcErrorMsg = ""
ENDIF   

lcButton = Request.Form("btnSubmit")

*** Deal with the Shipping Flags 
*** this is kinda twisted because we may not have customer
*** info at this point in the order process - so we 
*** grab and store Foreign and ShipDisks values in a Session
lcForeign = Request.Form("Foreign")
IF lcButton="Recalc"
   IF EMPTY(lcForeign)
      lcForeign = "Off"
   ENDIF
   Session.SetSessionVar("Foreign",lcForeign)
ELSE
   lcForeign = Session.GetSessionVar("Foreign")
   IF EMPTY(lcForeign)
     lcForeign = "Off"
   ENDIF
ENDIF

lcShipDisks = Request.Form("ShipDisks")
IF lcButton = "Recalc"
   IF EMPTY(lcShipDisks)
      lcShipDisks = "Off"
   ENDIF
   Session.SetSessionVar("ShipDisks",lcShipDisks)
ELSE
   lcShipDisks = Session.GetSessionVar("ShipDisks")
ENDIF

lnInvPk = VAL( Session.GetSessionVar("InvoicePK") )

*** Now load the line items
oLineItems = CREATE([WWS_CLASS_TLINEITEMS])
#IF WWSTORE_USE_SQL_TABLES
oLineItems.SetSQLObject(Server.owwStoreSQL)
#ENDIF

oLineItems.LoadLineItems(lnInvPK,1)

*** Create a temp invoice so we can total everything
loInv = CREATE([WWS_CLASS_INVOICE])
#IF WWSTORE_USE_SQL_TABLES
loInv.SetSQLObject(Server.owwStoreSQL)
#ENDIF
loInv.New()  && Create Temporary Invoice Object

*** IF we already have a temporary invoice number use it
IF !EMPTY(lnInvPK)
   loInv.oData.PK = lnInvPK  && Assign existing invoice Pk to it
ENDIF

*** And assign the lineitems to it
loInv.oLineItems = oLineItems  && loItems

*** Update shipping flags used when calculating totals
IF lcForeign = "True"
   *** Dummy foreign country set on empty Cust record
   loInv.oCustomer.oData.CountryID = "MX"
ENDIF
loInv.oData.ShipDisks = (lcShipDisks="On")

*** check for Item Qty changes (Recalc)
IF lcButton = "Recalc"
	FOR x=1 to oLineItems.nCount
	  loRow = oLineItems.aRows[x]
	  	  
	  *** Update Qtys if changed on the Web Page! 
	  lcSkuQty = Request.Form("SKU_" + TRIM(loRow.Sku))
	  IF !EMPTY(lcSkuQty)
	     *** Update the current display array
	     loRow.Qty = val(lcSkuQty)
	     IF loRow.Qty < 0
	        loRow.Qty = 0
	     ENDIF
	     
	     *** If qty has changed
	     IF oLineItems.LoadItem(loRow.Pk) AND ;
	        loRow.Qty # oLineItems.oData.Qty
	 
	        IF loRow.Qty = 0 
	          *** Qty 0 - delete it!         
	          oLineItems.Delete()
	        ELSE
 	          *** Update the item stored on disk
	          oLineItems.oData.Qty = loRow.Qty
	          oLineItems.CalculateItemTotal()
	          oLineItems.Save()  && Save to disk
	        ENDIF
	 
	        *** And update the total on our display array 
	        loRow.ItemTotal = oLineItems.oData.ItemTotal 
	     ENDIF
	  ENDIF
	ENDFOR
ENDIF

*** And recalc and total the invoice
loInv.InvoiceTotal()

Session.SetSessionVar("ShoppingCartItems",TRANSFORM(loInv.oLineitems.nCount))
Session.SetSessionVar("ShoppingCartTotal",TRANSFORM(loInv.nSubTotal,"$$$,$$$.99"))

*** Set flag to let script page know whether we can check out
IF loInv.oData.InvTotal = 0
   plNoItems = .T.
ELSE
   plNoitems = .F.
ENDIF

*** Create the HTML from the LineItems
pcShoppingCart = loInv.HTMLLineItems(2,.T.,lcForeign)

*** And simply dump the strings into the HTML template
Response.ExpandTemplate(Config.cHTMLPagePath + "shoppingcart.wws")
ENDFUNC
* wwStore :: ShoppingCart.wws

************************************************************************
* wwStore :: RemoveItem
*********************************
***  Function:
***    Assume:
************************************************************************
FUNCTION RemoveItem
LOCAL lcSKU, loTL, lnInvPk

lcSKU = Request.QueryString("Sku")

*** We assign an invoice id whenever we add an item
*** If no ID exists - no items are in the cart
lnInvPk = VAL( Session.GetSessionVar("InvoicePK") )
IF lnInvPK = 0
   THIS.ErrorMsg("The shopping cart is empty")
   RETURN
ENDIF
   
*** We can delete by sku because the app
*** summarizes all SKUs into a single item!  
loTL = CREATE([WWS_CLASS_TLINEITEMS])
#IF WWSTORE_USE_SQL_TABLES
loTL.SetSQLObject(Server.owwStoreSQL)         
#ENDIF

loTL.DeleteLineItem(lcSKU,lnInvPK)

*** Redisplay the shopping cart
THIS.ShoppingCart()
   
ENDFUNC
* wwStore :: RemoveItem


************************************************************************
* wwStore :: Profile
*********************************
***  Function: Handles display of the profile. This is a dual function
***            method that handles either the standalone profile page
***            or the Order Profile page.
************************************************************************
FUNCTION Profile
PARAMETER pcErrorMsg
LOCAL lnCustPk, llSubmit
PRIVATE plNew, oCustomer, oLookups, oCust

*** See if we can get a customer ID
lnCustPk = VAL(Session.GetSessionVar("CustomerPK"))

*** Figure out where we need to go next
IF EMPTY(THIS.cNextMethod)
   THIS.cNextMethod = Request.QueryString("Next")
   IF EMPTY(THIS.cNextMethod)
        THIS.cNextMethod = "Default"
   Endif
ENDIF

*** Create customer object and assign our SQL handle (if any)
plNew = .F.
oCustomer = CREATE([WWS_CLASS_CUSTOMER])
#IF WWSTORE_USE_SQL_TABLES
oCustomer.SetSQLObject(Server.owwStoreSQL)
#ENDIF

IF EMPTY(lnCustPK)
   oCustomer.New()
   plNew = .T.
   Session.SetSessionVar("CustomerPk",oCustomer.oData.Pk)
ELSE
   IF !oCustomer.Load(lnCustPK)
   	  oCustomer.New()
   	  plNew = .T.
   ENDIF
ENDIF   

*** Error Message if any to display
IF VARTYPE(pcErrorMsg) # "C"
   pcErrorMsg = ""
ENDIF	

*** For easier display create a data reference
oCust = oCustomer.oData

IF Request.IsPostBack()
    oCust.Userid = Session.cSessionId

    *** Read Form vars into the Object
    Request.FormVarsToObject(oCust)
	
    *** Now perform any custom overrides
	oCust.CountryID = Request.Form("Country")

	oLookups = CREATE([WWS_CLASS_LOOKUPS])
   #IF WWSTORE_USE_SQL_TABLES
   oLookups.SetSQLObject(Server.owwStoreSQL)
   #ENDIF

	oCust.Country = oLookups.CountryIdToCountry(oCust.CountryId)

	IF oCust.State = "**"
	   oCust.State = ""
	ENDIF

	IF oCust.Country = "**"
    	oCust.CountryID = ""
 	ENDIF

	oCust.Email = lower(oCust.Email)
	oCust.Password = lower(oCust.Password)

	IF EMPTY(oCust.Password)
	  *** This is specific to the Web app - we don't enforce this
      *** this in the GUI app, hence Validate doesn't handle this
	  pcErrorMsg = "Your Profile Password may not be left blank." + CHR(13)
	ENDIF

	*** Error checking here
	IF !oCustomer.Validate()
	   pcErrorMsg = pcErrorMsg + oCustomer.cErrorMsg
	ENDIF

	*** If we have no error we can go on
	IF EMPTY(pcErrorMsg)
	   oCustomer.Save()  && Save to Disk
	   Session.SetSessionVar("CustomerPK",TRANS(oCust.PK))	
       IF !EMPTY(THIS.cNextMethod) AND ; 
          !INLIST(UPPER(THIS.cNextmethod),"PROFILE","ORDERPROFILE")
		   EVALUATE("THIS." + THIS.cNextMethod + "()")
		   RETURN
	   ENDIF   
	ENDIF
ENDIF

*** Just redisplay the current page
Response.ExpandTemplate( Request.GetPhysicalPath() )
ENDFUNC
* wwStore :: Profile 

************************************************************************
* wwStore :: OrderProfile
*********************************
***  Function:
***    Assume:
************************************************************************
FUNCTION OrderProfile

*** Check and make sure we have an invoice here
*** if not no items are in shopping cart - ie. direct access
*** Exist
lnInvPk = VAL(Session.GetSessionVar("InvoicePK"))
IF EMPTY(lnInvPK)
   THIS.ShoppingCart()
   RETURN
ENDIF

THIS.cNextMethod = "OrderForm"
THIS.Profile()

ENDFUNC
* wwStore :: OrderProfile


************************************************************************
* wwStore :: LogonProfile
*********************************
***  Function:
***    Assume:
************************************************************************
FUNCTION LogonProfile
LOCAL lcPassword, lcAction, llEmailPassword
PRIVATE pcEmail, pcErrorMsg

pcEmail = lower(Request.Form("Email"))
lcPassWord = lower(Request.Form("Password"))

*** Pointer so we know which request to run if we're OK
pcNextMethod = Request.QueryString("Next")
IF EMPTY(pcNextMethod)
   pcNextMethod = "Profile"
ENDIF   

lcAction = UPPER( Request.QueryString("Action") )
llEmailPassword = !EMPTY( Request.Form("EmailPassword") ) && Checkbox

*** Error Message to display if not blank
pcErrorMsg = ""

*** Create Customer object to do our dirty work
loCustomer = CREATE([WWS_CLASS_CUSTOMER])
#IF WWSTORE_USE_SQL_TABLES
loCustomer.SetSQLObject(Server.owwStoreSQL)
#ENDIF

DO CASE

  CASE EMPTY(pcEmail) and EMPTY(lcPassword)
      *** Just show the form
      pcErrorMsg = "Please fill in an email address and password."
      Response.ExpandTemplate( Request.GetPhysicalPath() )


  CASE llEmailPassword
      IF !loCustomer.Find("trim(email) == [" + pcEmail + "]" )

         pcErrorMsg = "The specified email address does not exist. Please sign up for a brand new account profile."

         *** Go to the profile page and display an error message
         THIS.Profile(pcErrorMsg)
      ELSE  
         IF EMPTY(loCustomer.oData.Password)
            loCustomer.oData.Password = LOWER(SUBSTR(SYS(2015),2))
            loCustomer.Save()
         ENDIF
	     THIS.SendEmail(pcEmail,Config.cStoreName + " Profile Password.",;
	                    "Your logon info for your online account is: "  +CRLF + CRLF +;
	                    "Username: " + pcEmail + CRLF +;
	                    "Password: " + loCustomer.oData.Password + CRLF + CRLF +;
	                    "The West Wind Team" + CRLF,,,.T.)
	                    
	     pcErrorMsg = "Check your email and then re-enter your password on this form."               
      ENDIF 	                    
  
      *** Just redisplay this form
      Response.ExpandTemplate( Request.GetPhysicalPath())


  CASE EMPTY(lcAction)
      IF loCustomer.nDataMode = 2
         llResult = loCustomer.Find("email like '" + pcEmail + "' and password='" + lcPassword + "'")
      ELSE
         llResult = loCustomer.Find("trim(email) == [" + pcEmail + "] and password = padr([" + lcPassword + "],10)")
      ENDIF
      
      IF !llResult
         *** Redisplay this form
         pcErrorMsg = "Invalid Password.<br>If you forgot your password check the <i>Forgot your Password?</i> checkbox."
         Response.ExpandTemplate( Config.cHTMLPagePath + "LogonProfile.wws") 
         RETURN
      ENDIF   
      
      *** Ok - logged in
     
      *** Now fix the current session by updating the CookieId with the User ID
      lcSessionId = loCustomer.oData.UserId
      IF EMPTY(loCustomer.oData.UserId)
         lcSessionId = SYS(2015)
         loCustomer.oData.UserId = SUBSTR(lcSessionID,2,9)
         loCustomer.Save()
      ENDIF
      
      *** Save the temporary invoice PK
      lcInvPK = Session.GetSessionVar("InvoicePK")
      
      *** Kill any existing sessions with the same ID
      Session.DeleteSession(lcSessionId)
      
      *** Find the current session and update the current SessionID
      IF !Session.LocateSession(Session.cSessionID)
         Session.NewSession()
      ENDIF
       
      *** Update the new session
      Session.SetSessionId(lcSessionID)
      Session.SetSessionVar("CookiesOn","True")
      Session.SetSessionVar("InvoicePK",lcInvPK)
      Session.SetSessionVar("CustomerPK",TRANS(loCustomer.oData.Pk))
            
      *** Force a new Cookie to be written with that value when page is built
      Response.cAutoSessionCookieName = Config.cCookieName
      Response.cAutoSessionCookie = loCustomer.oData.UserID
      Response.lAutoSessionCookiePersist = .T.
      

      *** Preset Foreign or US/Can status in session for shopping cart
      IF !INLIST(loCustomer.oData.CountryId,"US","CA")
         Session.SetSessionVar("Foreign","True")
      ENDIF         

      DO CASE 
       CASE pcNextMethod = "OrderProfile"
         THIS.StandardPage("Attaching to your profile",[<a href="orderprofile.wws">Click here</a> if your browser isn't navigating to the profile form automatically.],,1,"orderprofile.wws")
       CASE pcNextMethod = "Contest"  
         THIS.StandardPage("Attaching to your profile",[<a href="/webconnection/contest.wst">Click here</a> if your browser isn't navigating to the profile form automatically.],,1,"/webconnection/contest.wst")
       CASE pcNextMethod = "CodeSignup"  
         THIS.StandardPage("Attaching to your profile",[<a href="/webconnection/codesignup.wst">Click here</a> if your browser isn't navigating to the profile form automatically.],,1,"/webconnection/codesignup.wst")
       OTHERWISE
         THIS.StandardPage("Attaching to your profile",[<a href="orderprofile.wws">Click here</a> if your browser isn't navigating to the profile form automatically.],,1,"profile.wws")
      ENDCASE
ENDCASE

ENDFUNC
* wwStore :: LogonProfile


************************************************************************
* wwStore :: OrderForm
*********************************
***  Function: Handles the final validation and takes credit card info
***    Assume: Parameters are passed as PRIVATE here!
************************************************************************
FUNCTION OrderForm
PARAMETER pcErrorMsg, oCustomer

*** Private vars for the order form
IF VARTYPE(pcErrorMsg) # "C"
   pcErrorMsg = ""
ENDIF   

IF VARTYPE(pcNotes) # "C"
   pcNotes = ""
   pcCCType = ""
   pcCCCard = ""
   pcCCMonth = "01"
   pcCCYear = TRANSFORM(YEAR(DATE()) )
   pcHeardFrom = ""
   pcHeardFrom1 = "*** IF NOT IN LIST ***"
   pcPromoCode = ""
ENDIF   

*** We assign an invoice id whenever we add an item
*** If no ID exists - no items are in the cart
lnInvPk = VAL( Session.GetSessionVar("InvoicePK") )
IF EMPTY(lnInvPk)
   *** No items in the cart yet...
   THIS.ShoppingCart()
   RETURN
ENDIF   
lnCustPk = VAL( Session.GetSessionVar("CustomerPK") )
IF EMPTY(lnCustPk)
   THIS.ShoppingCart()
   RETURN
ENDIF   

*** Good order - let's build it!
oCustomer = CREATE([WWS_CLASS_CUSTOMER])
#IF WWSTORE_USE_SQL_TABLES
oCustomer.SetSQLObject(Server.owwStoreSQL)
#ENDIF

IF !oCustomer.Load(lnCustPk)
   THIS.ShoppingCart()
   RETURN
ENDIF   

*** Now load the line items
oLineItems = CREATE([WWS_CLASS_TLINEITEMS])
#IF WWSTORE_USE_SQL_TABLES
oLineItems.SetSQLObject(Server.owwStoreSQL)
#ENDIF

oLineItems.LoadLineItems(lnInvPK,1)

*** Create a temp invoice so we can total everything
loInv = CREATE([WWS_CLASS_INVOICE])
#IF WWSTORE_USE_SQL_TABLES
loInv.SetSQLObject(Server.owwStoreSQL)
#ENDIF

oInvoice = loInv
loInv.New()  && Create Temporary Invoice Object

loInv.oData.PK = lnInvPK  && Assign existing invoice Pk to it
loInv.oData.ShipDisks = (Session.GetSessionVar("ShipDisks")="On")
loInv.cShipCountry = oCustomer.oData.CountryId

loInv.oCustomer = oCustomer

*** And assign the lineitems to it
loInv.oLineItems = oLineItems

*** Calculate shipping and final totals
loInv.InvoiceTotal()

*** Create the HTML from the LineItems
pcItemList = loInv.HTMLLineItems(0,.T.)

*** Display the page
Response.ExpandTemplate(Config.cHTMLPagePath + "OrderForm.wws")
ENDFUNC
* wwStore :: OrderForm
 
************************************************************************
* wwStore :: SubmitOrder
*********************************
***  Function:
***    Assume:
************************************************************************
FUNCTION SubmitOrder
LOCAL lnInvPK, lnCustPK, lcPayPalReturn

SET STEP ON 

*** Allow printing an order form not an invoice
llPrintOnly = ( Request.Form("btnSubmit") = "Print" )

*** If we're coming back from PayPal set this as a flag
*** Value will be Success or Cancel
lcPayPalReturn = Request.QueryString("PayPal")

*** Restore POST buffer - PayPal will return a GET 
*** We saved the post buffer - this will restore everything
*** as if we were submitting the form again
IF !EMPTY(lcPayPalReturn)
   Request.cFormVars = Session.GetSessionVar("PayPalState")
ENDIF

*** We assign an invoice id whenever we add an item
*** If no ID exists - no items are in the cart
lnInvPk = VAL( Session.GetSessionVar("InvoicePK") )
IF lnInvPK = 0
   THIS.ShoppingCart()
   RETURN
ENDIF
lnCustPk = VAL( Session.GetSessionVar("CustomerPK") )
IF EMPTY(lnCustPk)
   THIS.Profile()
   RETURN
ENDIF   

*** Good order - let's build it!
oCustomer = CREATE([WWS_CLASS_CUSTOMER])
#IF WWSTORE_USE_SQL_TABLES
oCustomer.SetSQLObject(Server.owwStoreSQL)
#ENDIF

*** If we can't find the customer
*** we can't process order - exit
IF !oCustomer.Load(lnCustPk)
   THIS.Profile()
   RETURN
ENDIF   
oCust = oCustomer.oData

oLineItems = CREATE([WWS_CLASS_LINEITEMS])
#IF WWSTORE_USE_SQL_TABLES
oLineItems.SetSQLObject(Server.owwStoreSQL)
#ENDIF

*** Create new invoice and assign our 'existing' InvPk
oInvoice = CREATE([WWS_CLASS_INVOICE])
#IF WWSTORE_USE_SQL_TABLES
oInvoice.SetSQLObject(Server.owwStoreSQL)
#ENDIF
oInvoice.New()
oInvoice.oData.PK = lnInvPk  

*** Load the Form Variables into the Invoice object
Request.FormVarsToObject(oInvoice.oData)

*** Override Properties that need special attention

*** Shipping assigned to invoice so we can always
*** track where the order went
oInvoice.oData.Shipping = oCust.Shipping

*** Custom Expiration Formatting from drop downs
oInvoice.oData.CCExp = Request.Form("ccMonth") + "/" + Request.Form("ccYear")

pcCCType = Request.Form("CCType")
pcHeardFrom = Request.Form("HeardFrom")
pcHeardFrom1 = Request.Form("HeardFrom1")
pcNotes = Request.Form("Notes")
pcCCCard = Request.Form("cc")
pcCCMonth = Request.Form("ccMonth")
pcCCYear = Request.Form("ccYear")
pcPromoCode = Request.Form("OrderCode")

oCustomer.oData.Referral = pcHeardFrom
IF oCustomer.oData.Referral = "Please "
   *oCustomer.oData.Referral = ""
   *** Do nothing leave it alone
ENDIF
IF oCustomer.oData.Referral = "Other" 
   oCustomer.oData.Referral = pcHeardFrom1
ENDIF   

*** Ship Disks option stored in Session
oInvoice.oData.ShipDisks = (Session.GetSessionVar("ShipDisks")="On")

*** Add Customer Object
oInvoice.oCustomer = oCustomer

*** Load Temporary LineItems 
*oLineItems.LoadLineItems(lnInvPK)

*** Run the query to retrieve the lineitems explicitly because we're pulling from the TLineitems table
*** and we want to avoid pulling fields we don't need here so we can easily update.
*** NOTE: We're pulling these from the TLineitems table
oLineItems.Query("select Pk,Storepk,Invpk,Custpk,Itempk,Sku,Descript,Extratext," + ;
                  "Qty,Price,Itemtotal,Discount,Weight,Type,Xml" + ;
                  " FROM wws_tLineItems WHERE InvPK=" + TRANSFORM(lnInvPk))
IF oLineItems.lError
   THIS.OrderForm(oLineItems.cErrorMsg,oCustomer)
   RETURN .F.
ENDIF

*** Load up the lineitems object from the above cursor   
IF oLineItems.LoadFromCursor() < 1
   THIS.OrderForm(oLineItems.cErrorMsg,oCustomer)
   RETURN .F.
ENDIF

*** We now have compatible LineItems so
*** assign to our live lineitems on the invoice
oInvoice.oLineItems = oLineItems

*** Force an empty record to be loaded so we can
*** get the right structure for wws_lineitems table
*** so our INSERT statement will be correct
oInvoice.oLineItems.GetBlankRecord()  

*** If we have no items exit and return 
IF oInvoice.oLineItems.nCount = 0
   THIS.OrderForm("This order contains no lineItems",oCustomer)
   RETURN
ENDIF   

*** Total out the invoice
oInvoice.InvoiceTotal()

*** Now let's check our validation rules for
*** the actual invoice
IF !oInvoice.Validate(llPrintOnly)
   THIS.OrderForm(DisplayMemo(oInvoice.cErrorMsg))
   RETURN
ENDIF   


IF oInvoice.oData.CCType == "PP"
   IF EMPTY(lcPayPalReturn)  && Only process if we're not on the return
      this.PayPalRedirection(oInvoice)
      RETURN
   ELSE
      IF lcPayPalReturn = "Success"
         oInvoice.oData.ccResult = "PROCESSED"
         oInvoice.oData.CC = "paid with Paypal"
      ELSE
         THIS.OrderForm("PayPal Processing failed")
         RETURN
      ENDIF
   ENDIF
ELSE
#IF WWSTORE_PROCESS_CC_ONLINE
*** Skip CC Processing if Promo Code is applied
*** Use offline processing explicitly
IF EMPTY( oInvoice.oData.OrderCode )

   *** Process Credit Cards if we're configured for it
   *** Uses the App.Ini configuration settings for providers
   *** see the docs for wwccProcessing in the Help File
   SET PROCEDURE TO ccProcessing additive
   IF !oInvoice.ValidateCreditCard(Config.cCCProcessor,;
                                   Config.cCCStore,;
                                   Config.cCCStorePassword,;
                                   "https://www.west-wind.com/wwstore/orderform.wws")
      DO CASE
         CASE oInvoice.oData.ccResult = "FAILED"
            *** Request failed - accept the order anyway because it's on our end
            *** So do nothing 
         CASE oInvoice.oData.ccResult = "DECLINED" OR oInvoice.oData.ccResult = "FRAUD"
            *** Return and show the error
            THIS.OrderForm(oInvoice.cErrorMsg)
            RETURN
      ENDCASE
   ENDIF

ENDIF
#ENDIF
ENDIF
  
*** Save the invoice and clear the current invoice setting
IF !oInvoice.Save()
   *** Save Failed - Redisplay the orderform with error msg
   pcNotes = oInvoice.oData.Notes
   THIS.OrderForm( DisplayMemo(oInvoice.cErrorMsg) )
   RETURN
ENDIF
      
*** Clear out the session Invoice - new invoice from here.
Session.SetSessionVar("InvoicePK","")
Session.SetSessionVar("ShoppingCartItems","") && Item Count
Session.SetSessionVar("ShoppingCartTotal","") && Total $
Session.SetSessionVar("PayPalState","")

*** Check for XML Mode output
IF THIS.nResultMode = 2
  THIS.ReturnObjectXML(oInvoice)
  RETURN
ENDIF   

*** Display the order confirmation page 
THIS.OrderConfirmation(oInvoice,llPrintOnly)
ENDFUNC
* wwStore :: SubmitOrder.wws


************************************************************************
* wwStore :: HandlePayPalRedirection
****************************************
***  Function: Sets up the Redirection to PayPal 
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION PayPalRedirection(loInvoice)

#IF .F.
LOCAL Request as wwRequest
#ENDIF

SET PROCEDURE TO PayPalHelper ADDITIVE

SET STEP ON 

*** Save our POST data in the Session object
*** We'll retrieve it when we come back
Session.SetSessionVar("PayPalState",Request.cFormVars)

loPayPal = CREATEOBJECT("PayPalHelper")

loPayPal.cPayPalBaseUrl = Config.cCCPayPalUrl
loPayPal.cAccountEmail = Config.cCCPayPalEmail
loPayPal.cLogoUrl = Config.cCCPayPalLogoUrl

loPayPal.nAmount = loInvoice.oData.InvTotal
loPayPal.cInvoiceNo = loInvoice.oData.InvNo
loPayPal.cBuyerEmail = loInvoice.oCustomer.oData.Email
loPayPal.cItemName = Config.cStoreName + " Order #" + loInvoice.oData.InvNo

loPayPal.cSuccessUrl = Request.GetCurrenturl() + "PayPal=Success"
loPayPal.cCancelUrl = Request.GetCurrentUrl() + "PayPal=Cancel"

Response.Redirect( loPayPal.GetSubmitUrl() )
ENDFUNC
*  wwStore :: HandlePayPalRedirection

************************************************************************
* wwStore :: IPNConfirmation
****************************************
***  Function:
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION PayPalIPNConfirmation()

lcInvoiceNo = Request.Form["invoice"]

oInvoice = CREATE([WWS_CLASS_INVOICE])
#IF WWSTORE_USE_SQL_TABLES
oInvoice.SetSQLObject(Server.owwStoreSQL)
#ENDIF

LOCAL Server as wwServer
IF !oInvoice.LoadInvoiceByInvoiceNo(lcInvoiceNo)
   Server.LogRequest("Invalid PayPal IPN Request - Invalid Invoice Number","",0,.t.)
   RETURN
ENDIF

*** Check for already done - shouldn't happen but just in case
IF oInvoice.oData.CCResult = "APPROVED"
   RETURN
ENDIF   

SET PROCEDURE TO PayPalHelper ADDITIVE 
loPayPal = CREATEOBJECT("PayPalHelper")
llResult = loPayPal.IPNPostDataToPayPal(Config.cCCPayPalUrl, Config.cCCPayPalEmail,;
                                        oInvoice.oData.InvTotal)

IF Result
   oInvoice.oData.CCResult = "APPROVED"
   oInvoice.Save()
ELSE
   Server.LogRequest(loPayPal.cLastResponse,"",0,.t.)
ENDIF
      

ENDFUNC
*  wwStore :: IPNConfirmation


************************************************************************
* wwStore :: SubmitXMLOrder
*********************************
***  Function: Imports an order from an XML upload
***    Assume: XML is correct format
***            Only limited error checking at this time
************************************************************************
FUNCTION SubmitXMLOrder

IF !THIS.Login(Config.cAdminUser)
   RETURN
ENDIF

*** Retrieve XML input if passed
lcXML = Request.FormXML()

IF lcXML <> "<?xml"
   Response.Write("Error: No XML input provided.")
   RETURN
ENDIF

*** Create an Invoice object and initialize
loInv = CREATE([WWS_CLASS_INVOICE])
#IF WWSTORE_USE_SQL_TABLES
loInv.SetSQLObject(Server.owwStoreSQL)
#ENDIF

loInv.Load(0)

*** Create wwXML and allow nested hierarchical objects
loXML = CREATE("wwXML")
loXML.lRecurseObjects = .T.
loXML.XMLToObject(lcXML,loInv)

IF !(loInv.oData.Pk # 0 AND loInv.oCustomer.oData.pk # 0)
   Response.Write( "Error: Invalid Order Info." + loXML.cErrorMsg)
   RETURN
ENDIF

*** Must fix up invoice for PK conflicts
loInv.CheckInvoiceForPkConflict()
   
*** Write the invoice   
loInv.Save()

*** Simple response for client
Response.Write("OK")

ENDFUNC
* wwStore :: SubmitXMLOrder
  


************************************************************************
* wwStore :: OrderConformation
*********************************
***  Function: Successful order placed
***    Assume:
************************************************************************
FUNCTION OrderConfirmation
LPARAMETER loInvoice, llPrintonly
PRIVATE pcTemplate, oInvoice

*** We can call this directly with an invoice and display it
IF VARTYPE(loInvoice) # "O"
	lnInvPk = VAL(Request.QueryString("InvoicePK"))
	IF EMPTY(lnInvPK)
	   THIS.Errormsg("Invalid Invoice ID","Couldn't open the requested invoice")
	   RETURN
	ENDIF

	loInvoice = CREATE([WWS_CLASS_INVOICE])
   #IF WWSTORE_USE_SQL_TABLES
   loInvoice.SetSQLObject(Server.owwStoreSQL)
   #ENDIF

	loInv.cShippingBehaviorClass = "cwwShippingBehavior"
	loInv.cTaxBehaviorClass = "cwwTaxBehavior"
	loInv.lNoTaxTotal = .F.

	IF !loInvoice.Load(lnInvPK)
	   THIS.Errormsg("Unable to load invoice","Couldn't open the requested invoice")
	ENDIF
ENDIF

oInvoice = loInvoice

*** Now render the invoice portion
oInv = oInvoice.oData
oCust = oInvoice.oCustomer.oData

*** Retrieve and merge the invoice body only
loEval = CREATE("wwEval")
pcInvoiceTemplate = loEval.MergeText( Extract(File2Var(Config.cHTMLPagePath + "templates\invoice.wc"),"<body>","</body>") )

*** Send Email Confirmation
IF !llPrintOnly
   loIP = CREATE("wwIPStuff")
   loIP.cMailServer=Config.cMailServer
   loIP.cSenderEmail=Config.cMailFromEmail
   loIP.cSenderName=Config.cMailFrom
   loIP.cCCList = Config.cMailCC
   loIP.cRecipient = oCust.Email
   loIP.cSubject = "West Wind Technologies Order Confirmation: " + oInv.Invno

    *** Mail Confirmation has custom HTML text and embeds invoice
   loIP.cMessage = loEval.MergeText(File2Var(Config.cHTMLPagePath + "templates\mailconfirmation.wc") )

   loIP.cContentType = "text/html"
   loIP.SendMailAsync()
   
   Response.ExpandTemplate( Config.cHTMLPagePath + "orderconfirmation.wws")
ELSE
   Response.ExpandTemplate( Config.cHTMLPagePath + "printorder.wws")
ENDIF   

ENDFUNC
* wwStore :: OrderConformation



************************************************************************

***   MAINTANENCE FUNCTIONS

************************************************************************


************************************************************************
* wwStore :: MaintShowInvoices
*********************************
***  Function:
***    Assume:
************************************************************************
FUNCTION MaintShowInvoices
LOCAL oInvoices, oHTMLForm, lcCustId, lcAction

IF !THIS.Login(Config.cAdminUser)
   RETURN
ENDIF   

loInvoice = CREATE([WWS_CLASS_INVOICE])
#IF WWSTORE_USE_SQL_TABLES
loInvoice.SetSQLObject(Server.owwStoreSQL)
#ENDIF

lcAction = Request.QueryString("Action")
DO CASE
   CASE EMPTY(lcAction)
     *** Just display the list
     loInvoice.MaintInvoiceList()
     
     Response.HTMLHeader("Invoice Display")
     Response.Write('<a href="default.htm">Back to Admin Page</a><p>')
     loSC = CREATE("wwWebStoreShowCursor")
     loSC.lSumNumerics = .T.
     loSC.ShowCursor()
     Response.Write( loSC.GetOutput() ) 
   CASE lcAction = "Show"
     lnPk = VAL( Request.QueryString("PK") )
     IF lnPK # 0       
	     IF !loInvoice.Load( lnPK )
	        THIS.ErrorMsg("Couldn't load invoice")
	        RETURN
	     ENDIF
	 ELSE
	    lcInvNo = Request.QueryString("InvNo")
	    IF !loInvoice.LoadInvoiceByInvoiceNo(lcInvNo)
	        THIS.ErrorMsg("Couldn't load invoice")
	        RETURN
	    ENDIF
	 ENDIF

    oInvoice = loInvoice
    loInvoice.InvoiceTotal()

	oInv = oInvoice.oData
	oCust = oInvoice.oCustomer.oData
	
	IF THIS.nResultMode = 2
	   THIS.ReturnObjectXML(loInvoice,"invoice",.T.) &&Recurse
	   RETURN
	ENDIF

	*** Retrieve and merge the invoice body only
	loEval = CREATE("wwEval")
	pcInvoiceTemplate = loEval.MergeText( Extract(File2Var(Config.cHTMLPagePath + "templates\invoice.wc"),"<body>","</body>") )
	lcHTML = [<html><head><link rel="stylesheet" type="text/css" href="..\wwstore.css"></head><body>] + ;
	         [<h1>Invoice Display</h1><a href="MaintShowInvoices.wws">Invoice List</a> | <a href="] + ;
	         Request.GetRelativeSecureLink([MaintShowInvoices.wws?Action=Show&Display=XML&PK=] + TRANS(oInv.pk) + [],!CONFIG.lSecureOrderpage) +;
	         [">Download Invoice as XML</a> | ] + ;
            [<a href="MaintccProcessInvoice.wws?PK=] +TRANSFORM(oInv.pk) +[&instancing=single">Process CC Card</a> | ] +;
            [<a href="MaintConfirmOrder.wws?PK=] + TRANSFORM(oInv.Pk) + [">Send Confirmation Email</a><p>] + ;
	         pcInvoiceTemplate + ;
            "<hr>" + ;
            "<b>Card Result:</b> " + oInv.ccResult + "<br>"  +;
            "<b>Processor Result:</b><br>" + oInv.ccResultX + ;
	         [</body></html>]
	
    Response.ContentTypeHeader()
    Response.Write(lcHTML)
   CASE lcAction = "Delete"
     lnPk = VAL( Request.QueryString("PK") )
     IF lnPK # 0       
	     IF !loInvoice.Load( lnPK )
	        THIS.ErrorMsg("Couldn't load invoice")
	        RETURN
	     ENDIF
	 ELSE
	    lcInvNo = Request.QueryString("InvNo")
	    IF !loInvoice.LoadInvoiceByInvoiceNo(lcInvNo)
	        THIS.ErrorMsg("Couldn't load invoice")
	        RETURN
	    ENDIF
	 ENDIF
     loInvoice.Delete()
     Response.redirect("MaintShowInvoices.wws") 
   OTHERWISE
      THIS.ERRORMsg("Invalid Action")
ENDCASE


RETURN
* wwStore :: ShowInvoices

************************************************************************
* wwStore :: PurgeInvoices
*********************************
***  Function: Purges invoices on the Web site for security 
***            purposes.
************************************************************************
FUNCTION PurgeInvoices
LOCAL oInv, lnCount
PRIVATE ldDate

IF !THIS.Login(Config.cAdminUser)
   RETURN
ENDIF   

ldDate = CTOD( Request.Form("Date") )
IF EMPTY(ldDate)
   THIS.ErrorMsg("Invalid date entered","Invoices have not been purged." + ADMINFOOTER)
   RETURN
ENDIF

oInv = CREATEOBJECT([WWS_CLASS_INVOICE])
#IF WWSTORE_USE_SQL_TABLES
oInv.SetSQLObject(Server.owwStoreSQL)
#ENDIF

oInv.Execute("delete from wws_invoice where Pk=0")

IF oInv.Query("SELECT pk FROM wws_invoice WHERE InvDate <= ?ldDate","TKillInvoices") < 1
   THIS.ErrorMsg("No matching invoices to purge","Invoices have not been purged." +;
                 ADMINFOOTER )
   RETURN
ENDIF


lnCount = 0
SELE TKillInvoices
SCAN  
   oInv.Delete(TKillInvoices.pk)
   lnCount = lnCount + 1
ENDSCAN

THIS.StandardPage("Purging Complete","Purged invoices dated before: " + DTOC(ldDate) + ".<br>"+;
                                     TRANSFORM(lnCount) + " Invoices erased.")
ENDFUNC
* wwStore :: PurgeInvoices

************************************************************************
* wwStore :: MaintDownloadFlag
*********************************
***  Function: 
***    Assume:
************************************************************************
FUNCTION MaintDownloadFlag

IF !THIS.Login(Config.cAdminUser)
   RETURN
ENDIF   

lnPk = VAL( Request.QueryString("PK") )
IF lnPK = 0
  THIS.ErrorMsg("Invalid PK")
  RETURN
ENDIF

oInvoice = CREATE([WWS_CLASS_INVOICE])
#IF WWSTORE_USE_SQL_TABLES
oInvoice.SetSQLObject(Server.owwStoreSQL)
#ENDIF

IF !oInvoice.Load(lnPK)    
   THIS.ErrorMsg("Invalid PK")
   RETURN
ENDIF

*** Flip the switch
oInvoice.oData.Downloaded = !oInvoice.oData.Downloaded

oInvoice.Save()

THIS.MaintShowInvoices()

ENDFUNC
* wwStore :: MaintDownloadFlag

************************************************************************
* wwStore :: MaintExportOrders
*********************************
***  Function: Exports orders to XML.
***    Assume:
************************************************************************
FUNCTION MaintExportOrders
LOCAL lcFilter, llNoClear, loInv

IF !THIS.Login(Config.cAdminUser)
   RETURN
ENDIF   

lcFilter = Request.Form("Filter")
IF EMPTY(lcFilter)
   lcFilter = Request.QueryString("Filter")
ENDIF   

*** Allow messages to stay loaded
llMarkDownloaded = !EMPTY( Request.QueryString("SetDownloadFlag") )


loInv = CREATE([WWS_CLASS_INVOICE])
#IF WWSTORE_USE_SQL_TABLES
loInv.SetSQLObject(Server.owwStoreSQL)
#ENDIF


IF EMPTY(lcFilter)
   *** Default filter exports all uncompleted orders
   IF llMarkDownloaded
      IF loInv.nDataMode = 0
         lcFilter = " !downloaded"
      ELSE
         lcFilter = " downloaded=0"
      ENDIF
   ELSE
      lcFilter = ""
   ENDIF
ENDIF

lcXML = loInv.ExportOrdersToXML(lcFilter,llMarkDownLoaded) && Mark all as downloaded
Response.ContentTypeHeader( "text/xml" )
Response.Write( lcXML )

ENDFUNC
* wwStore :: MaintExportOrders


************************************************************************
* wwStore :: MaintExportCustomers
*********************************
***  Function:
***    Assume:
************************************************************************
FUNCTION MaintExportCustomers
LOCAL loIP, loCust, lcDate

IF !THIS.Login(Config.cAdminUser)
   RETURN
ENDIF   

lcDate = Request.Form("StartDate")
IF EMPTY(lcDate)
   lcDate = Request.QueryString("StartDate")
   IF EMPTY(lcDate)
      lcDate = "01/01/1990"
   ENDIF
ENDIF

loCust=CREATE([WWS_CLASS_CUSTOMER])
#IF WWSTORE_USE_SQL_TABLES
loCust.SetSQLObject(Server.owwStoreSQL)
#ENDIF

IF loCust.nDataMode = 0
   loCust.Query([SELECT * WHERE Updated > {] + lcDate +[}],"Tquery")
ELSE
   loCust.Query([SELECT * from wws_customers  where  DateDiff(day,updated,'] + lcDate +[') > 0],"Tquery")
ENDIF

IF loCust.lError
   RESPONSE.Write("Error: " + loCust.cErrormsg)
   RETURN
ENDIF

SELE TQuery
  
*** Package up the current cursor into an wwIPStuff Cursor Package
THIS.ReturnCursorXML("customers","customer")

RETURN
ENDFUNC
* wwStore :: MaintExportOrders

************************************************************************
* wwStore :: MaintImportInventory
*********************************
***  Function: Imports inventory uploaded from a client machine.
************************************************************************
FUNCTION MaintImportInventory
LOCAL lcFName, oItem, loXML

IF !THIS.Login(Config.cAdminUser)
   RETURN
ENDIF   

lcAction=lower(REQUEST.QueryString("Action"))

*** Import entire file
lcXML = Request.FormXML()
IF EMPTY(lcXML)
   Response.Write("Error: No data sent.")
   RETURN
ENDIF
IF lcXML # "<?xml"
   Response.Write("Error: No XML sent to server.")
   RETURN
ENDIF

DO CASE
CASE lcAction = "update"
    lcSku = Request.QueryString("SKU")
    IF EMPTY(lcSKU)
       Response.Write("Error: No sku specified.")
       RETURN
    ENDIF

    *** Load Item - if not found create new one
	oItem = CREATE([WWS_CLASS_ITEM])
   #IF WWSTORE_USE_SQL_TABLES
   oItem.SetSQLObject(Server.owwStoreSQL)
   #ENDIF

	IF !oItem.GetItemBySku(lcSKU)
	   oItem.New()
	ENDIF
	
	*** Object passed over XML 
	loXML = CREATE("wwXML")
	loXML.XMLToObject(lcXML,oItem.oData)
	IF EMPTY(oItem.oData.Sku)
       Response.Write("Error: Invalid XML." + loXML.cerrorMsg)
	ENDIF

	*** XML bug: CRs and CRLFs are turned into CHR(10)s - fix!
	oItem.oData.Categories = STRTRAN(oItem.oData.Categories,CHR(10),CHR(13))
   oItem.Save()
OTHERWISE
    *** Check for validity - server side schema support in the future
    IF not "<items>" $ lcXML and not "<item>" $ lcXML
       Response.Write("Error: Invalid XML passed to server.")
       RETURN
    ENDIF
    
	oItem = CREATE([WWS_CLASS_ITEM])
   #IF WWSTORE_USE_SQL_TABLES
   oItem.SetSQLObject(Server.owwStoreSQL)
   #ENDIF

   *** Grab all items into a cursor
   IF oItem.nDataMOde = 2
      *** Grab an empty cursor
      oItem.cSQLCursor = oItem.cAlias
      oItem.Execute("Select * from " + oItem.cAlias + " WHERE 1=0")
   ENDIF
   
   *** Delete all items
	oItem.Execute("delete FROM " + oItem.cAlias)

    *** Cursor passed as XML - import directly into cursor/table
	loXML = CREATE("wwXML")
	loXML.XMLToCursor(lcXML,oItem.cAlias)
   IF loXML.lError
      THIS.ErrorMsg("Error Converting Data",loXML.cErrorMsg)
      RETURN
   ENDIF

      
   SCAN
      lnRecNo = RECNO()

      *** Grab the record
      SCATTER NAME oItem.oData MEMO

      *** XML bug: CRs and CRLFs are turned into CHR(10)s - fix!
      oItem.oData.Categories = STRTRAN(oItem.oData.Categories,CHR(10),CHR(13))
                  
      oItem.Save()
      
      GOTO lnRecno
   ENDSCAN

	oItem.Reindex()
ENDCASE	

RESPONSE.Write("OK")
ENDFUNC

************************************************************************
* wwStore :: MaintccProcessInvoice
****************************************
***  Function:
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION MaintccProcessInvoice()
LOCAL lnPk, loInv

IF !THIS.Login(Config.cAdminUser)
   RETURN
ENDIF

lnPk = VAL( Request.Querystring("pk") )

loInv = CREATEOBJECT("cInvoice")
#IF WWSTORE_USE_SQL_TABLES
loInv.SetSQLObject(Server.owwStoreSQL)
#ENDIF

IF !loInv.Load(lnPk)
   THIS.ErrorMsg("Error Loading Invoice",loInv.cErrorMsg,,5,"MaintShowInvoices.wws")
   RETURN
ENDIF

IF loInv.oData.ccResult = "APPROVED"
   THIS.ErrorMsg("Invoice was already processed","This invoice's credit card was already processed and had been approved.",,5,"MaintShowInvoices.wws")
   RETURN
ENDIF

loInv.ValidateCreditCard(Config.cCCProcessor,Config.cCCStore,Config.cCCStorePassword,"https://www.west-wind.com/wwstore/orderform.wws")
loInv.Save()

Response.Redirect( "MaintShowInvoices.wws?Action=Show&pk=" +TRANSFORM(lnPK) )   
ENDFUNC
*  wwStore :: MaintccProcessInvoice

************************************************************************
* wwStore :: MaintConfirmOrder
****************************************
***  Function:
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION MaintConfirmOrder()
LOCAL lnPK, lcReturnURL,loInv

IF !THIS.Login(Config.cAdminUser)
   RETURN
ENDIF

lnPk = VAL( Request.Querystring("pk") )
lcReturnUrl = "MaintShowInvoices.wws?Action=Show&pk=" + TRANSFORM(lnPK)

loInv = CREATEOBJECT("cInvoice")
#IF WWSTORE_USE_SQL_TABLES
loInv.SetSQLObject(Server.owwStoreSQL)
#ENDIF

IF !loInv.Load(lnPk)
   THIS.ErrorMsg("Error Loading Invoice",loInv.cErrorMsg,,5,lcReturnUrl)
   RETURN
ENDIF

IF loInv.oData.ccResult # "APPROVED"
   THIS.ErrorMsg("Invoice is not Approved","Make sure you process this order first.",,5,lcReturnUrl)
   RETURN
ENDIF

loInv.Emailconfirmation(Config.cMailServer,Config.cMailFromEmail,Config.cMailFrom,.F.)

THIS.StandardPage("Email Sent","",,5,lcReturnUrl)
ENDFUNC
*  wwStore :: ConfirmOrder


************************************************************************
* wwStore :: MaintUpdateClientInventory
****************************************
***  Function: Updates the inventory on the client side from the
***            Web Site. Sends items selected to download or the
***            whole file. Client side picks what to update
************************************************************************
FUNCTION MaintExportInventory
LOCAL loXML as wwXML, loItem as cItem

IF !THIS.Login(Config.cAdminUser)
   RETURN
ENDIF   

Response.ContentTypeHeader("text/xml")

lcSKU = Request.QueryString("Sku")
loXML = CREATEOBJECT("wwXML")

loItem = CREATEOBJECT("cItem")
#IF WWSTORE_USE_SQL_TABLES
loItem.SetSQLObject(Server.owwStoreSQL)
#ENDIF

IF EMPTY(lcSKU)
   *** Return the entire inventory
   loItem.Query("SELECT * from wws_items","TStoreItems")
   Response.Write(loXML.CursorToXML("Items","Item"))
   RETURN
ENDIF   

IF !loItem.getitembysku(lcSku)
   Response.Write("<wwstore>" + loXML.createerrorxml("Invalid Sku specified.") + "</wwstore>")
   RETURN
ENDIF

Response.Write(loXML.objecttoxml(loItem.odata))
ENDFUNC
*  wwStore :: MaintUpdateClientInventory


************************************************************************
* wwStore :: MaintEditItems
*********************************
***  Function:
***    Assume:
************************************************************************
FUNCTION MaintEditItems
LOCAL lcAction, lcSKU, lcID, lnPK

IF !THIS.Login(Config.cAdminUser)
   RETURN
ENDIF   

lcAction = Request.QueryString("Action")
lcSku = Request.QueryString("Sku")
lcID = Request.QueryString("ID")

pcMessage = ""

#IF !WWSTORE_USE_SQL_TABLES
   IF !USED("wws_items")
      USE wws_items in 0
   ENDIF

   SELE wws_items
   SET ORDER TO Sku
#ELSE
   Server.owwStoreSQL.cSQL = "select * from wws_items order by sku"  
   Server.owwStoreSQL.cSQLCursor = "wws_items"
   * _cliptext = THIS.oSQL.cSQL
   lnResult = Server.owwStoreSQL.Execute()
   Server.owwStoreSQL.cSQLCursor = "TSQLQuery"
   IF lnResult # 1
        THIS.seterror(Server.owwStoreSQL.cErrorMsg)
      RETURN .F.
   ENDIF
#ENDIF

Response.ContentTypeHeader()
Response.Write([<html><head><link rel="stylesheet" type="text/css" href="..\wwstore.css"></head><body>] + ;
               [<h1>Inventory Item Editor</h1><hr>] )

loSC = CREATE("wwWebStoreShowCursor")
loSC.cBaseUrl = "MaintEditItems.wws?"
loSC.cKeyField = "pk"
loSC.cKeyType = "N"
loSC.cTableFieldList = "sku,pk,[<b>] + descript + [</b>] as Item_Description,price,stock,NoWeb"
loSC.cTableEditFieldList = "sku,descript,lDescript,price,special,stock,weight,physical,noweb,mfr,Url,categories,Itemimage,sortorder,regtext,regpass"
loSC.cExtraTableTags = [class="body"]

*loSC.lAllowDelete = .F.
*loSC.lAllowEdit = .F.

DO CASE
*** Have to manually handle the SQL Update and Inserts
*** Since wwShowCursor uses 'LOCATE/REPLACE/APPEND BLANK'
*#IF WWSTORE_USE_SQL_TABLES
CASE lcAction == "Save" 
      oItem = CREATEOBJECT("cItem")
      #IF WWSTORE_USE_SQL_TABLES      
      oItem.SetSQLObject(Server.owwStoreSQL)
      #ENDIF
      IF !oItem.Load(VAL(lcId))
         THIS.ErrorMsg("Invalid SKU","Can't save this item...")
         RETURN
      ENDIF

      Request.FormVarsToObject(oItem.oData)

      IF !oItem.Save()
         THIS.ErrorMsg("Update failed",oItem.cErrorMsg)
         RETURN
      ENDIF
      
      *** Just redisplay the list page
      Response.Redirect("MaintEditItems.wws")
CASE lcAction == "SaveNew"
      oItem = CREATEOBJECT("cItem")
      #IF WWSTORE_USE_SQL_TABLES
      oItem.SetSQLObject(Server.owwStoreSQL)
      #ENDIF
      oItem.New()
      
      *** We need to save our PK
      lnPk = oItem.oData.Pk
      
      Request.FormVarsToObject(oItem.oData)
      
      *** Now write saved PK over possible PK from data
      oItem.oData.Pk = lnPK
      
      IF !oItem.Save()
         THIS.ErrorMsg("Update failed",oItem.cErrorMsg)
         RETURN
      ENDIF
      
      *** Just redisplay the list page
      Response.Redirect("MaintEditItems.wws")
*#ENDIF
OTHERWISE
   *** With DBF tables everything this automatic
   loSC.EditTable()
ENDCASE  

Response.Write( loSC.GetOutput() )

Response.HTMLFooter([<hr><a href="MaintEditItems.wws">Item List</a> | <a href="default.htm">Admin Page</a>])
RETURN
ENDFUNC
* wwStore :: MaintEditItems


************************************************************************
* wwStore :: MaintReindex
*********************************
***  Function:
***    Assume:
************************************************************************
FUNCTION MaintReindex

IF !THIS.Login(Config.cAdminUser)
   RETURN
ENDIF   

#IF WWSTORE_USE_SQL_TABLES
   THIS.ErrorMsg("Reindexing not supported",;
                     "Since you are using a SQL datasource reindexing is not supported nor required.<p><a href='admin/'>Back to Admin Page</a>",,5,"admin/")
   RETURN 
#ENDIF

oAdmin = CREATE("cwwStoreAdmin")
oAdmin.ReindexAll()

THIS.StandardPage("Reindexing Complete",;
                  oAdmin.cErrorMsg)

ENDFUNC
* wwStore :: MaintReindex


************************************************************************
* wwStore :: MaintUpdateStructures
*********************************
***  Function:
***    Assume:
************************************************************************
FUNCTION MaintUpdateStructures

IF !THIS.Login(Config.cAdminUser)
   RETURN
ENDIF   

oAdmin = CREATE("cwwStoreAdmin")
oAdmin.UpdateStructures(".\wwstore\")

THIS.StandardPage("Structure Update Complete",;
                  oAdmin.cErrorMsg)

ENDFUNC
* wwStore :: MaintUpdateStructures


************************************************************************
* wwStore :: ReturnCursor
*********************************
PROTECTED FUNCTION ReturnCursor
LPARAMETER lcTable, lcRow

IF !ISDIR(".\TEMP")
  MD .\temp
ENDIF

lcFile = SYS(2015)
SELECT * FROM (Alias()) INTO TABLE (".\temp\" + lcFile) 
USE

loIP=CREATE("wwIPStuff")
Response.Write( loIp.EncodeDbf(".\temp\" + lcFile + ".dbf",.t.) )

ERASE (".\temp\" + lcFile + ".*")

RETURN
* wwStore ReturnCursor

************************************************************************
* wwStore :: ReturnCursorXML
*********************************
PROTECTED FUNCTION ReturnCursorXML
LPARAMETER lcTable, lcRow

loXML = CREATE("wwXML")
loXML.cDocRootName = Config.cXMLDocRoot
loXML.nCreateDataStructure = 1

Response.ContentTypeHeader("text/xml")
Response.Write( loXML.CursorToXML(lcTable,lcRow) )


RETURN
ENDFUNC
* wwStore :: ReturnCursorXML

************************************************************************
* wwStore :: ReturnObjectXML
*********************************
PROTECTED FUNCTION ReturnObjectXML
LPARAMETER loObject, lcRow, llRecurse, lcPropertyExclusions

loXML = CREATE("wwXML")
loXML.cDocRootName = Config.cXMLDocRoot

IF llRecurse
   loXML.lRecurseObjects = llRecurse
   loXML.cPropertyExclusionList = loXML.cPropertyExclusionList + ;
    ",calias,cfilename,cdatapath,csql,csqlcursor,lerror,cerrormsg,cresultxml,cconnectstring,cidtable,nupdatemode,osql,vresult,ndatamode,nresultmode," 
 ELSE
   loXML.nCreateDataStructure = 1  && Schema
ENDIF

IF !EMPTY(lcPropertyExclusions)
   loXML.cPropertyExclusionList = loXML.cPropertyExclusionList + ;
     lcPropertyExclusions
ENDIF   

Response.ContentTypeHeader("text/xml")
Response.Write( loXML.ObjectToXML(loObject,lcRow) )

RETURN
ENDFUNC
* wwStore :: ReturnObjectXML

************************************************************************
* wwStore :: GetBanner
*********************************
***  Function: Retrieves banner and returns string
************************************************************************
FUNCTION GetBanner

*** Banner Display - get random banner
loBanner = create("wwBanner")
loBanner.cBannerFile = "wwStoreBanners"
loBanner.cAlias = "wwStoreBanners"

RETURN loBanner.GetBanner(-1) 
* wwStore :: GetBanner


************************************************************************
* wwStore :: BannerClick
*********************************
***  Function: Counts banner clicks and redirects to real link 
************************************************************************
Function BannerClick

lcID = Request.QueryString("ID")

loBanner = create("wwBanner")
loBanner.cBannerFile = "wwStoreBanners"
loBanner.cAlias = "wwStoreBanners"

Response.Write( loBanner.ClickBanner(lcID) )

RETURN
* EOF BannerClick

************************************************************************
* wwStore :: MaintBannerAdmin
*********************************
***  Function: Banner Addministration link - handles adding, deleting
***            and editing of banners.
************************************************************************
FUNCTION MaintBannerAdmin

*** Only allow Auth users into the admin features
IF !THIS.Login(CONFIG.cAdminUser)
   RETURN
ENDIF   

loBanner = CREATE("wwBanner")
loBanner.cBannerFile = "wwStoreBanners"
loBanner.cAlias = "wwStoreBanners"

loBanner.cBaseURL="MaintBannerAdmin.wws?"

Response.Write(loBanner.HandleHTMLRequest(Request))

ENDFUNC
* WestWind :: BannerAdmin

************************************************************************
* wwStore :: ShoppingCartItems
****************************************
***  Function:
***    Assume:
************************************************************************
FUNCTION  ShoppingCartItems()
LOCAL lcItems

#IF .F. 
LOCAL Request as wwRequest, Response as wwResponse
#ENDIF

lcItems = Session.GetSessionVar("ShoppingCartItems")
IF !EMPTY(lcItems)
   IF lcItems = "1"
      lcItems = "1 item"
   ELSE
      lcItems = lcItems + " items"
   ENDIF
   RETURN "(" + lcItems + ", " + Session.GetSessionVar("ShoppingCartTotal") + ")"
ENDIF

RETURN  "(0 items, $0.00)"
ENDFUNC
*  wwStore :: ShoppingCartItems


************************************************************************
* wwStore :: Categorylist
*********************************
***  Function: Creates the Category list as part of the 
***            toolbar portion of the display
************************************************************************
FUNCTION Categorylist
LOCAL lcOutput, oLookups

*** See if the output is cached
lcOutput = Server.oCache.GetItem("wwstore_categorylist")
IF !ISNULL(lcOutput)
   RETURN lcOutput
ENDIF

*** Check if already used
IF !USED("_TLookups")
   oLookups = CREATE([WWS_CLASS_LOOKUPS])
   #IF WWSTORE_USE_SQL_TABLES
   oLookups.SetSQLObject(Server.owwStoreSQL)
   #ENDIF

   oLookups.GetCategories("_TLookups",,.T.)
ELSE
   *** Just select it
   SELE _TLookups
   LOCATE
ENDIF

IF !USED("_TLOOKUPS")
   RETURN "*** Couldn't retrieve lookups"
ENDIF

*** Build a simple string outptu from the categories
*** HTML includes specific HTML formatting for hover
*** buttons and underline adding to the look and feel
lcOutput = ""

SCAN
 lcoutput = lcOutput + ;
   [<tr><td width=100% align="right" class="menulink">] +;
   [<a href="itemlist.wws?Category=] + UrlEncode(TRIM(cData1)) + ;
   [" class="menulink">]+TRIM(cData1) + [</a></td></tr>]+ CRLF + ;
   [<tr><td height="1"><img src="space.gif" width="100%" height="1"></td></tr>] + CRLF
ENDSCAN

*** Add to Cache
Server.oCache.AddItem("wwstore_categorylist",lcOutput)

RETURN lcOutput
ENDFUNC
* wwStore :: Catogorylist


************************************************************************
* wwStore :: SendEmail
*********************************
***  Function:
***    Assume:
************************************************************************
PROTECTED FUNCTION SendEmail
LPARAMETER lcRecipient, lcSubject, lcBody, lcContentType, lcAttachment,llnocc

lcContentType=IIF(EMPTY(lcContentType),"text/plain",lcContentType)


loIP = CREATE("wwIPStuff")
loIP.cMailServer=Config.cMailServer
loIP.cSenderEmail=Config.cMailFromEmail
loIP.cSenderName=Config.cMailFrom

IF !llNoCC
   loIP.cCCList = Config.cMailCC
ENDIF

loIP.cRecipient = lcRecipient
	
loIP.cSubject = lcSubject
loIP.cMessage = lcBody
	
loIP.cContentType = lcContentType

loIP.SendMailAsync()

ENDFUNC
* wwStore :: SendEmail

************************************************************************
* wwStore :: ErrorMsg
****************************************
***  Function:
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION ErrorMsg
PARAMETER lcHeader, lcBody, lvHeader, lnRefresh, lcRefreshUrl

lcHeader=IIF(EMPTY(lcHeader),"Error",lcHeader)
lvHeader=IIF(VARTYPE(lvHeader) $ "CO",lvHeader,"FORCE RELOAD")
lcBody=IIF(EMPTY(lcBody),"",lcBody)
lnRefresh = IIF(EMPTY(lnRefresh),0,lnRefresh)
IF lnRefresh > 0
   lcRefreshUrl=IIF(EMPTY(lcRefreshUrl),"",lcRefreshUrl)
ENDIF

*** Make sure we have a valid object since we might be in a fatal error condition
*** If not we can't spit out a message - the DLL must handle the empty output
IF TYPE("THIS.oResponse")="O" AND !ISNULL(THIS.oResponse)
    THIS.oResponse.Rewind()
    
    *** Default Content Type Header
    THIS.oResponse.ExpandTemplate(Config.cHTMLPagePath + "errormsg.wws",lvHeader)
 
    THIS.oResponse.NoOutput(.T.)
ENDIF

ENDFUNC
*  wwStore :: ErrorMsg

************************************************************************
* wwStore :: ClearSession
*********************************
***  Function:
***    Assume:
***      Pass:
***    Return:
************************************************************************
FUNCTION CLEARSESSION

*** Clear the cookie
loHeader = CREATE("wwHTTPHeader")
loHeader.DefaultHeader()
loHeader.AddCookie(Config.cCookieName,"")

lcGoto = Request.QueryString("Next")
DO CASE 
CASE lcGoto = "Contest"
   lcLink = "/webconnection/contest.wst"
CASE lcGoto="Default"
   lcLink = "Default.wws"
OTHERWISE
   lcLink = "profile.wws"
ENDCASE

THIS.ErrorMsg("Profile link cleared",;
              "The profile has been reset. Hang on returning to profile page...",;
              loHeader,2,lcLink)

RETURN

************************************************************************
* wwStore :: Login
*********************************
***  Function: Override default Login to support XML response
***    Assume:
***      Pass:
***    Return:
************************************************************************
*!*	FUNCTION Login
*!*	LPARAMETER lcLogin

*!*	IF THIS.nResultMode = 2 && XML
*!*	   IF !DoDefault(lcLogin)
*!*	      loXML = CREATE("wwXML")
*!*	      lcXML = loXML.CreateErrorXML("Invalid Logon to server.")
*!*	      lcXML = loXML.cXMLHeader + lcXML
*!*	MessageBox(Response.GetOutput(.T.))      
*!*	*  RETURN .F.
*!*	      Response.Clear()
*!*	      Response.ContentTypeHeader("text/xml")
*!*	      Response.Write(lcXML)
*!*	      RETURN .F.
*!*	   ENDIF
*!*	ELSE
*!*	   RETURN DoDefault(lcLogin)
*!*	ENDIF

ENDDEFINE


DEFINE CLASS wwWebStoreShowCursor as wwShowCursor

cTableBorder = "0"
cCellPadding = "3"
cExtraTableTags = [ class="blackborder" ]
cHeaderColor = "White"
cHeaderBGColor = "Navy"
cTableWidth = "95%"
lAlternateRows = .T.
cALTERNATINGBGCOLOR = "#B5C7D6"

ENDDEFINE

