*
*
*	Robin.prg -- set up Robin's favorites
*
*
LPARAMETERS ;
	lxWork	as	string,  ;
	lx2		as	variant, ;
	lx3		as	variant, ;
	lx4		as	variant, ;
	lx5		as	variant
*
*	06/07/2004 --- establish baseline development environment
*																		
WAIT clear
CLEAR TYPEAHEAD
CLOSE all
CLEAR DLLS 
CLEAR EVENTS 
CLEAR FIELDS 
CLEAR GETS 
CLEAR MACROS 
CLEAR MENUS 
CLEAR POPUPS	
CLEAR PROGRAM 
CLEAR PROMPT 
CLEAR READ ALL
CLEAR TYPEAHEAD 
CLEAR WINDOWS
CLEAR
ON KEY				&& eliminate nasty kestroke interpreter ( esp CTRL+Q )
ON ERROR 			&& 01/06/2006 -- remove any error code
SET status bar on	&& show the rows and columns in when editting
SET clock status	&& show the clock in the status bar
*
*	09/08/2003 -- restore VFP defaults after running Maxwin...
*
SET CENTURY			ON	&& mm/dd/yyyy not mm/dd/yy
SET CENTURY TO 19 ROLLOVER 80 && 12/19/2003 -- won't handle dates after 2080
SET CPDIALOG 		OFF && 02/08/2005
SET DELETED			ON  && 02/08/2005
SET EXACT			ON	
SET EXCLUSIVE 		OFF && 02/08/2005
SET FULLPATH        OFF && 11/12/2006
SET HELP			ON  && 10/14/2005
SET MULTILOCKS		OFF	&& disallow 
SET PRINT			OFF && default when starting VFP 5
SET REPROCESS TO	0	&& failed locking retries
SET RESOURCE		ON	&&  Allow FOXUSER.DBF
SET SAFETY			ON	&& ask when erasing a file
SET sysmenu to 		default 
SET TALK			ON	&& jabber, jabber, jabber
SET TYPEAHEAD		TO  1024 && 07/26/2004 -- typehead may have up to 32,768 bytes in its buffer
*
*/RPC 09/09/2003 -- control printer font for VFP command window output 
*
SET printer font "Lucida Console",9 STYLE "B"

PRIVATE ;
	lcEMessage				as	string

LOCAL	;
	lcCDrive				as	string, ;
	lcLastDefaultDirectory	as	string, ;
	lcLastDir				as	string, ;
	llReturn				as	boolean, ;
	lnParmError				as	number

lcCDrive					=	"C:\"
lcEMessage					=	""
lcLastDefaultDirectory		=	"LastDefaultDirectory.dbf"
lcLastDir					=	JUSTSTEM( lcLastDefaultDirectory )
llReturn					= 	.T.
lnParmError					=	0

*!*	SET STEP ON && DEBUG

IF .not. FILE( lcLastDefaultDirectory )

	CD ( JUSTPATH( lcLastDefaultDirectory )  )

	CREATE TABLE	(	lcLastDir ) ;
					(	cLastDir	c(128), ;
						tLastDir	t )

ENDIF 
					
IF  PCOUNT() = 0 
	lnParmError = lnParmError + 1
ENDIF 

IF 	VARTYPE( lxWork ) # "C" 
	lnParmError = lnParmError + 2
ENDIF 
	
IF 	VARTYPE( lxWork ) = "C" 

	lxWork = UPPER( ALLTRIM( lxWork ) ) 

	IF  lxWork	=	 "?"
		
		lxWork	=	GETDIR( )
		
	ENDIF 
		
	IF  .not. DIRECTORY( lxWork ) 
			
		lnParmError = lnParmError + 4

	ENDIF 

ENDIF 

IF lnParmError > 0

	IF lnParmError > 3
	
		IF 6 # MESSAGEBOX( "Value passed" + ;
							IIF(lnParmError = 4, ;
								" '" + ALLTRIM( lxwork ) + "' ", ;
								" " ) + ;
							"was not a valid directory" + ;
							SPACE(5) + CHR(13) + CHR(13) + ;
							"Do you want to re-establish the current working directory?" + ;
							SPACE(5) + CHR(13) + ;
							"( Reply 'No' to leave everything as-is )" + ;
							SPACE(5), ;
							4 + ; && [Yes] [No]
							32, ; && ? question mark icon
							"lnParmError = " + ALLTRIM( STR( lnParmError ) ) )
			llReturn = .F.
							
		endif
	
	ENDIF 

	IF llReturn 

		IF .not. USED( lcLastDir )

			SELECT 0
			USE ( lcLastDefaultDirectory ) ;
				shared 

		ENDIF 

		IF  USED( lcLastDir )

			GOTO bottom
			 
			IF .not. EMPTY( &lcLastDir..cLastDir ) .and. ;
				DIRECTORY( &lcLastDir..cLastDir )
				
				lxwork = &lcLastDir..cLastDir 
				
			ENDIF 
			
		ENDIF 

		IF	EMPTY( lxWork ) .or. ;
			.not. DIRECTORY( lxWork )
			
			lxWork	=	ADDBS( SYS(5) + SYS(2003) )

		ENDIF 

	ENDIF 

ENDIF 

IF	llReturn

	*/Robinc 03/26/2004 --- Remove window ("Properties")
	IF 	WEXIST( "Properties" )
		RELEASE window ( "Properties" )
	endif
	*/RobinC 04/10/2004 --- New class 'ErrorHandler'
	IF  TYPE( '_VFP' )	=	"O"
		
*!*			_VFP.Top		=	0
*!*			_VFP.Left		=	0
*!*			_VFP.Width		=	SYSMETRIC(1)
*!*			_vfp.Height		=	SYSMETRIC(2) - SYSMETRIC(9)
*!*			
		IF	TYPE( '_VFP.ErrorHandler' ) = "O"
			REMOVEPROPERTY( _vfp, "ERRORHANDLER" )
		ENDIF

		IF	"5." $ VERSION()
		ELSE
			loError = CREATEOBJECT(	"ERRORHANDLER" )
			ADDPROPERTY( _vfp, "ErrorHandler", loError )
			ON error =	_VFP.ERRORHANDLER.HANDLEERROR( 	Error(), ;
														Message(), ;
														Message(1), ;
														LineNo(), ;
														SYS(16) )
		ENDIF

	ENDIF 

	=Defaults(	lxWork 	)

	IF	llReturn 
	
		lxwork = ALLTRIM( lxwork )
		
		TRY 
		
*!*				KEYBOARD	CHR(13)
*!*				KEYBOARD	"Note " + LongFileName( lxwork ) + ;
*!*							SPACE(1) + CHR(38) + CHR(38) + SPACE(1) + ;
*!*							JUSTFNAME( lcLastDefaultDirectory )
*!*				KEYBOARD	CHR(13) + CHR(13)

		CATCH 
		
			WAIT CLEAR 
			CLEAR TYPEAHEAD 
			WAIT WINDOW CHR(13) + SPACE(5) + ;
						LongFileName( lxwork ) + ;
						SPACE(5) + CHR(13)
		
		ENDTRY 

		IF	.not. llReturn .and. ;
			.not. EMPTY( lcEMessage )

			=MESSAGEBOX(	lcEMessage + SPACE(5), ;
							48, ;
							PROPER( SYS(16) ) ) 

		ENDIF
			
	ENDIF
	
ENDIF

*!*	SET STEP ON && DEBUG

IF .not. USED( lcLastDir )

	SELECT 0
	USE	( lcLastDefaultDirectory ) ;
		shared 
	
ENDIF

SELECT  ( lcLastDir )
INSERT INTO ( lcLastDir ) ;
			( 	cLastDir, ;
				tLastDir ) ;
	VALUES	(	ADDBS( SYS(5) + SYS(2003) ), ;
				DATETIME() )

*!*	WAIT CLEAR && DEBUG
*!*	CLEAR typeahead && DEBUG
*!*	BROWSE TITLE DBF() noedit && DEBUG
	
IF	USED( lcLastDir )

	USE IN ( lcLastDir )

ENDIF  

DO FORM JUMPSTART NAME goJumpStart LINKED  

IF VARTYPE( goJumpStart ) = "O"
	goJumpStart.PlaySound( "HELLO.WAV" )
ELSE
	=MESSAGEBOX( "Vartype( goJumpStart ) = '" + ;
				VARTYPE(goJumpStart) + "'" + SPACE(5) )
ENDIF 

READ EVENTS

IF 	.not. llReturn .and. ;
	.not. EMPTY( lcEMessage )
	
	=MESSAGEBOX(	lcEMessage, ;
					16, ;
					"Program terminated by error" )
	lcEMessage = ""
					
ENDIF 

RETURN llReturn && leave ROBIN.PRG
*------------------------------------------------------------------------------
*
*
	FUNCTION	LongFileName(	lcFileName, ;
								lx2, ;
								lx3,; 
								lx4, ;
								lx5, ;
								lx6 )
*
*	Handle those pesky embedded blanks
*
LOCAL	;
	lcReturn
	
lcReturn = "" && empty string	

IF	PCOUNT() = 1 .and.; 
	TYPE( 'lcFileName' ) = "C" .and. ;
	.not. EMPTY( lcFileName )
	
	IF	ATC(	SPACE(1), lcFileName, 1 )	=	0
		lcReturn = lcFileName
	ELSE
		IF	ATC(	'"', lcFileName, 1 ) = 0
			lcReturn = '"' + lcFileName + '"'
		ELSE
			lcReturn = "'" + lcFileName + "'"
		ENDIF
	ENDIF
	
ENDIF	
	
RETURN lcReturn && leave LongFileName() in Robin.prg	
*------------------------------------------------------------------------------
*
*
	Define Class ErrorHandler As Custom
*
*
*
*------------------------------------------------------------------------------
*
*
	Function Init()
		DODEFAULT()
		WAIT CLEAR 
		CLEAR TYPEAHEAD
*!*			WAIT WINDOW ;
*!*				CHR(13) + SPACE(5) + ;
*!*				"_VFP." + this.Name + ;
*!*				" initialized" + ;
*!*				SPACE(5) + CHR(13) + SPACE(5) + ;
*!*				TTOC( DATETIME() ) + ;
*!*				SPACE(5) + CHR(13) ;
*!*				NOWAIT  
	ENDFUNC	
*------------------------------------------------------------------------------
*
*
	Function HandleError(	lnError, ;
							lcMessage, ;
							lcMessage1, ;
							lnLineNo, ;
							lcCaption, ;
							lx6, ;
							lx7, ;
							lx8, ;
							lx9 )
	*
	*
	*	Handle program errors for TESTFICA
	*
	*	
	LOCAL	;
		lcProgram, ;
		lcString, ;
		;
		lnForNext, ;
		;
		llReturn
		
	llReturn = .T.
	*/RobinC 03/24/2004 --- Don't report any errors on Line # 0 ( VFP internal errors )
*!*		IF	TYPE( 'lnLineNo' ) = "N" .and. ;
*!*			( lnLineNo # 0 .or. .not. WEXIST( "project manager" ) )
			
		WAIT clear
		CLEAR TYPEAHEAD
		
		IF	UPPER( ALLTRIM( lcMessage1 ) ) = CHR(38) + "LCCOMMAND" .and. ;
			TYPE( 'lcCommand' ) = "C"

			lcMessage1 =	lcMessage1 + CHR(13) + ;
							"lcCommand = '" + lcCommand + "'"

		ENDIF
		
		DO	WHILE	AT( SPACE(3), lcMessage1, 1 ) # 0 .or. ;
					AT( CHR(9), lcMessage1, 1 ) # 0
		    lcMessage1 = CHRTRAN( lcMessage1, CHR(9), SPACE(1) )
			lcMessage1 = STRTRAN( lcMessage1, SPACE(2), SPACE(1) )
		ENDDO
		 	
		lcString = 	lcMessage + ;
					" ( " + alltrim( str( lnError ) ) ;
					+ " ) " + chr(13) + CHR(13) +;
					iif(.not.EMPTY(lcMessage1).and.lcMessage # lcMessage1, ;
						lcMessage1 + chr(13) + CHR(13), ;
						"" ) + ;
					"Line # " + alltrim( str( lnLineNo ) ) + chr(13) + chr(13) + ;
					"Calling stack:" 


		FOR lnForNext = 255 to 1 STEP -1

			lcProgram = Program( lnForNext )

			if	.not. EMPTY( lcProgram )	;
				.and.						;
				.not. INLIST(	lcProgram,	;
								"SCREEN.ERRORHANDLER.HANDLEERROR", ;
								"ON...",	;
								"ERRORRTN" )
			
				lcString	=	lcString + ;
								chr(13) + space(5) + lcProgram
								
			ENDIF

		NEXT lnForNext
					
		IF	6	#	MessageBox(	lcString + chr(13) + chr(13) + ;
								"Continue running program?", ;
								4 + ; && [Yes] [No]
								48, ; && ! exclamation point icon
								IIF(TYPE( 'lcCaption' ) = "C" .and. .not. empty( lcCaption ), ;
									lcCaption, ;
									"_VFP." + this.Name + ".HandleError()" )	)
			
			CANCEL && should this be QUIT ?
													
		ENDIF
						
*!*		ENDIF
													
	ENDFUNC && leave HANDLEERROR() in ROBIN.prg

*------------------------------------------------------------------------------
*
*
	Function RightClick(	lx1, ;
							lx2, ;
							lx3, ;
							lx4, ;
							lx5 )
	WAIT clear
	CLEAR TYPEAHEAD
	WAIT WINDOW CHR(13) + SPACE(5) + ;
				"Hello World" + ;
				SPACE(5) + CHR(13) 
				
	ENDFUNC && leave HANDLEERROR() in ROBIN.prg

Enddefine && leave  Class ERRORHANDLER As Custom
*------------------------------------------------------------------------------
*
*
	FUNCTION	Defaults(	lcdevchoice	as	string, ; 
							lx2, ;
							lx3, ;
							lx4, ;
							lx5 )
*
*	Originally written by Jon Melvin, at least that's where I got it
*
*	06/07/2004 ---- improve by allowing any directory as parameter
*					then build path for all sub-directories
*

*!*	WAIT clear
*!*	CLEAR typeahead
*!*	=MESSAGEBOX(	UPPER(ALLTRIM(lcDevchoice ) ) + CHR(13) + ;
*!*					UPPER(ALLTRIM(ADDBS(SYS(5) + SYS(2003) ) ) ) ) 

LOCAL	;
	lcAlias, ;
	lcEMessage, ;
	lcFolder, ;
	lcPath, ;
	;
	llReturn, ;
	;
	lnAlen, ;
	lnForNext	

lcAlias			=	ALIAS()
lcEMessage		=	""
lcFolder		=	""
lcPath			=	""
llReturn		=	.T.
lnAlen			=	0
lnForNext		=	0
*!*	WAIT CLEAR
*!*	CLEAR TYPEAHEAD

IF	PCOUNT() = 0

	lcdevchoice = PROPER( SYS(5) ) + PROPER( SYS( 2003 ) ) && 06/07/2004 -- Don't move...
	
ENDIF

IF	TYPE( 'lcdevchoice' ) # "C" .or. ;
	EMPTY( lcDevChoice ) .or. ;
	.not. DIRECTORY( lcDevChoice )

	llReturn	=	.F.
	lcEMessage	=	"'" + lcDevChoice + "' is not a valid directory"

ELSE 

	lcDevChoice	=	LongFileName(	lcDevChoice )
	***06/10/2004***WAIT window "About to:   CD  " + lcDevChoice && DEBUG
	CD &lcDevChoice
	DIMENSION laFolders[01,06]
	lnAlen = ADIR( laFolders, "*.*", "D" ) && array of directories
	
	FOR	lnForNext = 1 to lnAlen
	
		lcFolder = PROPER( ALLTRIM(laFolders[lnForNext,01] ) )
	
		IF	len( lcFolder ) = 6 .and. ;
			left( lcFolder, 4 ) = "Comp"
			
			loop && don't build paths for all companies in DOS PAYROLL
			
		ENDIF
			
		IF	ATC( "D", laFolders[lnForNext,05] ) # 0 .and. ;
			.not. INLIST( lcFolder, ".", ".." ) 
			
			lcPath = lcPath + laFolders[lnForNext,01] + ";"
		
		ENDIF
	
	NEXT lnForNext
*/Robinc 08/17/2005 --- don't add West wind directory	
	lcpath =	lcpath + ;
				IIF(	.not. EMPTY( lcPath ) .and. RIGHT( lcPath, 1 ) # ";", ;
						";", ;
						"" ) + ;
				"C:\util;C:\TEMP"
*/Robinc 08/17/2005 --- end

	set path to &lcpath
	
ENDIF 
						

IF  .not. llReturn .and. ;
	.not. EMPTY( lcEMessage )
	
	=MESSAGEBOX(	lcEmessage + SPACE(5), ;	
					48, ;
					PROPER( SYS(16) ) )
	
ENDIF

IF	USED( lcAlias )
	SELECT ( lcAlias )
ENDIF

RETURN llReturn && leave defaults.prg
