*:*****************************************************************************
*:
*: Procedure file: DEFAULT.PRG
*:         System: A Plus Micro -- Custom System
*:         Author: Doug Andrews / Robin Connelly
*:      Copyright (c) 1993, A Plus Micro Incorporated
*:  Last modified: 08/01/1994 at 15:53:22
*:
*:*****************************************************************************
*
*
*                  DEFAULT.PRG
*
*
*     1) Build memory table of SubDirectories
*
*     2) Build and activate POPUP of SubDirectories
*
*     3) Select Subdirectory, and
*        CD  xxxxxxxx
*
*     02/21/02 -- essentially re-written to use the GetDir() function...
*
*                                Ŀ
*Ĵ    Build Table of Sub-directories 
*                                
*
Parameters ;
   lddate, ;
   lx2,    ;
   lx3,    ;
   lx4,    ;
   lx5

PRIVATE ;
   lccommand,   ;
   lcHelp,      ; && 07/08/02
   lcPath,      ; && 02/21/02
   lcString,    ; && 10/25/02
   lcsubs,      ;
   lcsubdirs,   ;
   lcuppercdow, ;
   ;
   lnMaxKeyboardStringLength && 10/25/02
*
*   11/02/97 -- make sure we can see window screen
*
lcString = "" && 10/25/02
lnMaxKeyboardStringLength = 128 && 10/25/02 -- max length of a Keyboarded string

if VarType( _VFP ) = "O"

   with _VFP
   
      .Left        = 0
      .Top         = 0
      *
      *   Fixed size screen elements
      *
      *   Title and menu    38 
      *   Status bar        23 
      *   Docked toolbar    29 
      *
      *
      .Height      = sysmetric( 22 ) -                            ;
                                       ( ( 2 * sysmetric( 4 ) ) + ; && screen borders
                                         23                     + ; && status bar
                                         sysmetric( 9 )         + ; && Window title 
                                         sysmetric( 20 )        ) ; && Single line menu height
                                     +                            ;
                                         16                         && unknown, but needed adjustment
      .Width       = sysmetric( 21 ) - ( 2 * sysmetric( 3 ) ) && screen borders

   endwith

   if VarType( _screen ) = "O"

      with _Screen
   
         .Windowstate = 0 && Normal
         .fontname = 'Lucida Console'
         .fontsize = 8
         .fontbold = .F.
         .fontitalic = .F.
   
      endwith

   endif
   
else

   Move window screen center
   zoom window screen max

endif

set escape on
SET TALK OFF
clear
on key
on escape
set sysmenu to default
set status bar on
set hours to 12
set clock status
set help on && 7/14/97

if at( "06.", ;
       version(), ;
       1 ) <> 0
   *
   *   05/28/98 Version 6 important items
   *
   *   07/09/02 -- formerly:  D:\ROBIN'S OLD FILES\D DRIVE\MICROSOFT VISUAL STUDIO\VFP98
   *
   *
   lcHelp = addbs( left( sys(5) + sys(2003), ;
                         len( sys(5) + sys(2003) ) - 6 ) ) + ;
            "98vsa\1033\Foxhelp.chm"
   
   ***07/09/02***=Messagebox( lcHelp )
   
   if file( lcHelp )
   
      set help on
      set help to ( lcHelp ) && 07/09/02
   
   else
   
      wait clear
      clear typeahead
      =MessageBox( "Unable to 'Set Help on', can't find 'Foxhelp.chm'", ;
                   64, ;
                   "Help not available !" )
   
   endif
   
endif

if atc( "DTM_PLIB", ;
        set( "PROCEDURE" ), ;
        1 ) = 0 
   *
   *   Procedure library is active...
   *
   ***07/09/02***close all
   ***07/09/02***clear all
   release gcdefault && 07/09/02
   
endif
  
if VarType( m.gcDefault ) # "C" .or. ; && 02/21/02
   empty( m.gcDefault )
   
   Public        ;
      gcdefault
   
   m.gcdefault = addbs( sys(5) + sys(2003) ) && 03/31/97
   m.lcPath = LongFileName( m.gcDefault )
   set path to &lcpath
   m.lcGotDir = GetDir( m.gcDefault )
   m.gcDefault = LongFileName( m.lcGotDir )
   set default to &gcDefault

endif

if PCount() <> 1 .or. ;
   upper( type( "m.lddate" ) ) <> "D"
   
   m.lddate = date()
   
endif

m.lcuppercdow = upper( cdow( m.lddate ) ) && 'SUNDAY' thru 'SATURDAY'
*
*   7/26/96 -- added cute greeting...
*
Do case

   case m.lcuppercdow = "SUNDAY" && 1 of 7
   
      =wavtobell( "CLOSER" ) && 5/26/97 -- "Hold me closer..."

   case m.lcuppercdow = "MONDAY" && 2 of 7
   
      =wavtobell( "OPERA" ) && 5/26/97 -- Groucho Marx saying:
*                                        "And now, On with the opera..."
   case m.lcuppercdow = "TUESDAY" && 3 of 7

      =wavtobell( "NTKANSAS" )  &&  Dorothy from Wizard of OZ...
      
   case m.lcuppercdow = "WEDNESDAY" && 4 of 7

      =wavtobell( "OPERA" ) &&  -- Groucho Marx saying:
*                                        "And now, On with the opera..."      
   case m.lcuppercdow = "THURSDAY" && 5 of 7
   
      =wavtobell( "NTKANSAS" ) && Warner Brothers bear, "I'm a good boy"
   
   case m.lcuppercdow = "FRIDAY" && 6 of 7
   
      =wavtobell( "LUGNUTS" ) &&  -- Groucho Marx saying:
*                                        "And now, On with the opera..."
   case m.lcuppercdow = "SATURDAY" && 7 of 7
   
      =wavtobell( "THATSBTR" ) && Bugs bunny says "That's better"

   otherwise
      *
      *   Don't think we'll get here
      *
      =wavtobell( "911" ) && 5/26/97 -- "Call 911"
      
endcase

??chr(7) && Sound the bell, play the WAV file, etc.
=wavtobell( "DING" )
*
*   11/24/97 -- have some fun with wall paper on quote desk
*
Private ;
   lcPictureFile, ;
   ;
   lnDay
   
m.lnDay = day(date())
m.lcSecond = right( time(), 1 )

if m.lcSecond = "1" .or. ;
   m.lcSecond = "3" .or. ;
   m.lcSecond = "5" .or. ;
   m.lcSecond = "7" .or. ;
   m.lcSecond = "9"
   
   if ( int( m.lnDay / 2 ) * 2 ) = m.lnDay
      *
      *   Even numbered days of the month...
      *
      m.lcPictureFile = m.gcDefault + "BMP32\SCREEN.BMP"
   
   else
      *
      *   Odd numbered days of the month...
      *
      m.lcPictureFile = m.gcDefault + "ICO_32\QD.ICO"
   
   endif
   
else
   *
   *   01/06/98 -- discovered the RIGHT() funciton...
   *
   m.lcPictureFile = m.gcDefault + "testbp32\pogologo.bmp"

endif

if file( m.lcPictureFile )
   *
   *   Object oriented way of putting wallpaper on the VFP screen... 
   *
   _screen.picture = m.lcPictureFile

endif
*
*
*    Record important information in the command window 
*    for later use by programmer
*
*
wait clear && 10/23/01
clear typeahead && 10/23/01
lcString = ;
   "{Enter}" + ;
   " NOTE: CD " + LongFileName( Proper( ADDBS( sys(5) + sys(2003) ) ) ) + ;
   space(1) + ;
   chr(038) + chr(038) + ;
   SPACE(1) + ;
   "set the default directory" 
lcString = lcString + ;   
   IIF( LEN( lcString ) > lnMaxKeyBoardStringLength - 16, "", "{Enter}" ) + ;
   IIF( LEN( lcString ) > lnMaxKeyBoardStringLength - 16, "", "{Enter}" ) 
   
IF LEN( lcstring ) > lnMaxKeyboardStringLength

   lcString = LEFT( lcstring, lnMaxKeyBoardStringLength - 3 ) + "..."

ENDIF

ACTIVATE WINDOW command && 07/22/03 
KEYBOARD ;
   lcString ;
   PLAIN
lcString = ;
   "{Enter}" + ;
   " NOTE: DO " + ;
   LongFileName( Proper( ADDBS( SYS(2004) ) + "Default" ) ) + ;
   SPACE(1) + ;
   chr(038) + chr(038) + ;
   " VFP Start Directory"
lcString = lcString + ;
   IIF( LEN( lcString ) > lnMaxKeyBoardStringLength - 16, "", "{Enter}" ) + ;
   IIF( LEN( lcString ) > lnMaxKeyBoardStringLength - 16, "", "{Enter}" )
   
IF LEN( lcstring ) > lnMaxKeyboardStringLength

   lcString = LEFT( lcstring, lnMaxKeyBoardStringLength - 3 ) + "..."

ENDIF
 
KEYBOARD ;
    lcString ;
    PLAIN
Keyboard ; && 10/23/01 -- make sure we wind up on a blank line in the command window
   "{Enter}" + ;
   "{Enter}"  PLAIN  
m.lcCommand = Proper(                                                           ;
                      "set path to " +                                          ;
                      iif( directory( addbs( sys(5) + sys(2003) ) + "DBF" ),    ; && 02/21/02 -- make sure directory exists
                           addbs( sys(5) + sys(2003) ) + "DBF",                 ;
                           "" ) +                                               ;
                      iif( directory( addbs( sys(5) + sys(2003) ) + "PRG_32" ), ;
                           ";" + addbs( sys(5) + sys(2003) ) + "PRG_32",        ;
                           "" ) +                                               ;
                      iif( directory( addbs( sys(5) + sys(2003) ) + "SPR_32" ), ;
                           ";" + addbs( sys(5) + sys(2003) ) + "SPR_32",        ;
                           "" ) +                                               ;
                      iif( directory( addbs( sys(5) + sys(2003) ) + "MPR_32" ), ;
                           ";" + addbs( sys(5) + sys(2003) ) + "MPR_32",        ;
                           "" ) )
&lcCommand && 10/20/99 -- allow using DBF's immediately 
set printer font "Lucida Console", 8 Style 'N' && 10/21/99

IF _Screen.caption # VERSION()

   _Screen.Caption = VERSION() && 10/25/02

endif

RETURN && leave DEFAULT.PRG
*---------------------------------------------------------------------------------
*
*
     Function LongFileName( lcLFN, ;
                            lx2,   ;
                            lx3,   ;
                            lx4,   ;
                            lx5   )
*
*    10/20/98 -- properly build long file names for use by some VFP commands 
*
*    07/07/99 -- handle tag names as retrieved:  m.lcTag = Set( 'Order' )
*
*    Parameter
*    ---------
*
*    drive \ directory path \ filename  in a character string
*
*
*    Returns
*    -------
*
*    Alltrim'd, Proper'd character string, with surrounding single quote
*    marks if there are any embedded space(s) in the string.  If there are
*    embedded space(s) and single quote(s), then double quotes are used.
*
* 
*    Examples
*    --------
*
*    Visual Foxpro 6.0 ( and later ) support long file names as character
*    strings; however, a few commands require embedding long file names 
*    containing spaces or chr(32) inside quotation marks.  Listed below
*    are the Visual Foxpro commands and functions which accept filename and
*    pathing with a sample of how to properly handle long file names with each.
*
*    NOTE the same rules apply for mapped drives, e.g. 'M:'
*         and UNC ( Universal Naming Convention ), e.g.  '\\Server\path\' 
*
*    m.lcPath         = "C:\Program files\Universal Thread Navigator\Data\Admin\" && embedded blanks in path   
*    m.lcLongDoName   = LongFileName( m.lcPath + "Debug32.app" )
*    m.lcLongFileName = LongFileName( m.lcPath + "StateCd.DBF" ) 
*    m.lcLongPath     = LongFileName( m.lcPath )
*
*
*    Commands / Functions that need names embedded in quotes
*    -------------------------------------------------------
*
*       Cd &lcLongPath
*       do &lcLongDoName
*       Select * ;
*          from &lcLongFileName ;
*          where .not. empty( statecd ) ;
*          into dbf &lcLongTempFile
*       Use &lcLongFileName   
*
*
*    Commands / Functions that DO NOT need names embedded in quotes
*    --------------------------------------------------------------
*
*       Adir()
*       Append from 
*       Copy file 
*       Copy structure to 
*       Erase              <<---- code our own UDF EraseFile() instead 
*       File() 
*       Fopen()
*  
Local           ;
   lcReturnLFN, ;
   lcFileName,  ;
   ;
   lnAtc

assert PCount() = 1 ;
       Message "LongFileName() requires 1 parameter, received " + alltrim( str( PCount() ) ) + ;
       " called by " + Program( Program( -1 ) -1 )     
assert PCount() = 1 .and. ;
       VarType( m.lcLFN ) = "C" ;
       Message "LongFileName() requires parameter type 'C', received type '" + VarType( m.lcLFN ) + "'" + ;
       " called by " + Program( Program( -1 ) -1 )           
assert PCount() = 1 .and. ;
       VarType( m.lcLFN ) = "C" .and. ;
       .not. empty( m.lcLFN ) ;
       Message "LongFileName() requires non-empty character string parameter" + ;
       " called by " + Program( Program( -1 ) -1 )          
   
if VarType( goQuoteDesk_Timer ) = "O" .and. ; && 07/07/99 -- pause timer while 'Re_use' is running
   goQuoteDesk_Timer.enabled = .T.
   
   goQuoteDesk_Timer.enabled = .F. && inside LongFileName()
   
endif
*
*   Long file names present a unique challenge to older MSDOS and Windows 3 programs
*   in that space / blank is allowed as part of directory and file names, and not
*   restricted in use as the terminal delimiter of the name string.  Visual FoxPro
*   provides a work-around by allowing name string which contain blanks to be
*   embedded between quotation marks.  This is where those quotation marks are
*   added to the file name strings in Quote Desk 32.
*
do case

   case PCount() <> 1 .or. ;
        VarType( m.lcLFN ) <> "C" .or. ;
        empty( m.lcLFN )
        
        m.lcReturnLFN = "" && 07/07/99

   case Upper( left( m.lcLFN, ; && 07/07/99 -- support values from Set( 'Order' )
                     4 ) ) = "TAG " .and. ;
        atc( " of ", ;
             m.lcLFN, ;
             1 ) <> 0
        
        m.lnAtc = atc( " of ", ;
                       m.lcLFN, ;
                       1 )
        m.lcFileName = alltrim( substr( m.lcLFN, ;
                                        m.lnAtc + 4, ;
                                        len( m.lcLFN ) ) )
        
        if at( space(1), ;
               m.lcFileName, ;
               1 ) = 0
           *
           *   07/07/99 -- no embedded spaces in the filename portion of the 'TAG xxxx OF yyyyy' string
           *                
           m.lcReturnLFN = Upper( alltrim( m.lcLFN ) ) 
           
        else
           *
           *   07/07/99 -- embedded spaces in the filename portion of the 'TAG xxxx OF yyyyy' string
           *
           m.lcReturnLFN = left( m.lcLFN, ; && 07/07/99 -- save the 'TAG xxxx OF ' for now
                                 m.lnAtc + 3 ) 
       
           if at( "'", ;
                  m.lcFileName, ;
                  1 ) = 0
              
              m.lcReturnLFN = Upper( m.lcReturnLFN + ; && 07/07/99 -- single quotes in returned string
                                     "'" + ;
                                     m.lcFileName + ;
                                     "'" )
                                       
           else
           
              if at( '"', ;
                     m.lcFileName, ;
                     1 ) = 0
                     
                 m.lcReturnLFN = Upper( m.lcReturnLFN + ; && 07/07/99 -- double quotes in returned string
                                        '"' + ;
                                        m.lcFileName + ;
                                        '"' )
                                       
              else
              
                 =p_a_k_t_c( m.lcFileName, ;
                             "in " + m.lcLFN, ;
                             "Contains: blank and both 'single' and " + '"double"' + " quotes" )
                 m.lcReturnLFN = Upper( alltrim( m.lcLFN ) ) && 07/07/99 -- no embedded blanks

              endif
           
           endif 
        
        endif
        
   otherwise
        *
        *   Original coding to handle file names with paths 
        *
        if at( space(1), ;
               m.lcLFN, ;
               1 ) <> 0
           *
           *   12/11/98 -- only time we need to embed in quotes ( single or double ) 
           *               is when there are embedded blank(s)
           *
           if at( "'", ;
                  m.lcLFN, ;
                  1 ) = 0
              *
              *   Single quotes to embed filename string
              *
              m.lcReturnLFN = ;
                 "'" + ;
                 m.lcLFN + ;
                 "'"

           else
   
              if at( '"', ;
                     m.lcLFN, ;
                     1 ) = 0
                 *
                 *   Double quotes to embed filename string  
                 *
                 m.lcReturnLFN = ;
                    '"' + ;
                    m.lcLFN + ;
                    '"'
              else
   
                 =p_a_k_t_c( m.lcLFN, ;
                             "Contains: blank and both 'single' and " + '"double"' + " quotes" )
                 m.lcReturnLFN = Upper( alltrim( m.lcLFN ) ) && 07/07/99 -- no embedded blanks
   
              endif
   
           endif
           
        else
        
           m.lcReturnLFN = Upper( alltrim( m.lcLFN ) ) && 07/07/99 -- no embedded blanks
   
        endif

endcase

***03/22/99***=p_a_k_t_c( "Received     =    " + m.lcLFN, ;
            "Returning    =    " + m.lcReturnLFN ) && 12/11/98 -- debug

if VarType( goQuoteDesk_Timer ) = "O" .and. ; && 07/07/99 -- restore timer
   goQuoteDesk_Timer.enabled = .F. && inside LongFileName()

   goQuoteDesk_Timer.enabled = .T. && inside LongFileName()
   
endif

Return m.lcReturnLFN && leave LongFileName() in DTM_PLIB.PRG
*---------------------------------------------------------------------------------
*
*
     Function WAVTOBELL( lcwav,  ;
                         lx2,    ;
                         lx3,    ;
                         lx4,    ;
                         lx5    )
*
*
*   Set the bell to the passed WAV file...
*
*
Private ;
   lcwavfile

if PCount() = 1 .and. ;
   upper( type( "M.LCWAV" ) ) = "C" .and. ;
   .not. empty( m.lcwav )
   *
   *   Build complete WAV filename and set bell
   *
	IF	Upper( right( m.lcwav, 4 ) ) # ".WAV" 
	   
		lcwav = m.lcwav + ".WAV"

	ENDIF 

   IF FILE( ADDBS( SYS(2004) ) + lcWav )
   
   		m.lcWavFile = ADDBS( SYS(2004) ) + lcWav  
   		set bell to m.lcwavfile,1
   		
   ELSE
	      
		***07/23/03***
		=MESSAGEBOX(	CHR(13) + "Unable to locate: " + ADDBS( SYS(2004) ) + lcWav + CHR(13), ;
					 	64, ;
					 	"WAV files s/b in Foxpro load directory" )
	   
	   
	   m.lcwavfile = ;
	      iif( upper( type( "M.GCDEFAULT" ) ) = "C" .and. .not. empty( m.gcdefault ), ;
	      gcdefault, sys(5) + sys(2003) + "\" ) + ;
	      "WAV\" + m.lcwav + ".WAV"
	   
	   if file( lcwavfile )
	   
	      set bell to m.lcwavfile,1
	   
	   else

	      if file( m.lcwavfile )
	      
	         set bell to m.lcwavfile,1
	     
	      else
	      
	         m.lcwavfile = ;
	            iif( upper( type( "M.GCDEFAULT" ) ) = "C" .and. .not. empty( m.gcdefault ), ;
	            gcdefault, sys(5) + sys(2003) + "\" ) + ;
	            "MARXWAV\" + m.lcwav + ".WAV"

	         if file( m.lcwavfile )
	      
	            set bell to m.lcwavfile,1
	            
	         else
	         
	            m.lcwavfile = ;
	               iif( upper( type( "M.GCDEFAULT" ) ) = "C" .and. .not. empty( m.gcdefault ), ;
	               gcdefault, sys(5) + sys(2003) + "\" ) + ;
	               "AP_DTM\TESTWAV\" + m.lcwav + ".WAV"
	             
	            IF	file( m.lcwavfile )
	            
	               set bell to m.lcwavfile,1
	               
	            ELSE 
	               *
	               *   Probably don't want this message in production programs...
	               *
	               wait clear
	               clear typeahead
	               ***wait window ;
	                  chr(13) + space(10) + ;
	                  "DEBUG: can't find " + ;
	                  m.lcwavfile + ;
	                  space(10) + chr(13) 
	   
	            ENDIF 
	            
	         endif
	   
	      endif
	   
	   ENDIF
	   
	ENDIF 	   
   
endif

RETURN && leave WAVTOBELL() in DEFAULT.PRG
