lparameters tcCaption, ;
	tcFile, ;
	tcAppName
local llReturn, ;
	laFiles[1], ;
	lnFiles, ;
	lcDirectory, ;
	lnI, ;
	lcFile, ;
	lcExt
external array laZipFileInfo

* Ensure parameters were passed.

if vartype(tcCaption) <> 'C' or empty(tcCaption)
	return
endif vartype(tcCaption) <> 'C' ...

* Display a splash form if we have one.

do form ('INSTALL') name oSplash linked
doevents force

* Wait until the application that called us has terminated. If it doesn't do so
* voluntarily, we'll kill it. If we can't, display an error messsage and flag
* that we're done.

llReturn = WaitForAppTermination(tcCaption)
if not llReturn
	llReturn = KillProcess(tcCaption)
	if not llReturn
		messagebox('The application could not be terminated, so updates ' + ;
			'were not installed.', 48, tcCaption)
	endif not llReturn
endif not llReturn
if llReturn

* Read the file containing the list of files to copy into an array, erase the
* list file, and process each file.

	lnFiles = alines(laFiles, filetostr(tcFile), 4)
	erase (tcFile)
	if empty(tcAppName)
		lcDirectory = sys(5) + curdir()
	else
		lcDirectory = addbs(justpath(tcAppName))
	endif empty(tcAppName)
	lnI = 1
	do while lnI <= lnFiles
		lcFile = laFiles[lnI]
		lcExt  = upper(justext(lcFile))
		do case
			case not file(lcFile)

* If it's a zip file, unzip and erase it.

			case lcExt = 'ZIP'
				if not 'VFPCOMPRESSION' $ set('LIBRARY')
					set library to VFPCompression.FLL
				endif not 'VFPCOMPRESSION' $ set('LIBRARY')
				llReturn = UnzipQuick(fullpath(lcFile), lcDirectory)
				if llReturn
					erase (lcFile)
				endif llReturn

* Just copy the file.

			otherwise
				copy file (lcFile) to forcepath(lcFile, lcDirectory)
		endcase
		lnI = lnI + 1
	enddo while lnI <= lnFiles
endif llReturn

* Start the application if one was specified and it exists.

if not empty(tcAppName) and (file(tcAppName) or ;
	file(forceext(tcAppName, 'EXE')))
	run /n1 "&tcAppName"
endif not empty(tcAppName) ...
