* Returns the hWnd for the specified window.
* Note: be sure to pass tcWindowName if the application is a top-level form.

lparameters tcWindowName, ;
	tlExactName
local lcWindowName, ;
	lnFoxHWnd, ;
	lnHWndNext, ;
	lnBuffer, ;
	lcBuffer, ;
	lcOurClass, ;
	lcClass

* Define some constants and WinAPI functions.

#define GW_OWNER 4
#define GW_HWNDFIRST 0
#define GW_HWNDNEXT 2
#define SW_SHOWNORMAL 1
#define cnWINDOW_TITLE_LEN 128
declare integer GetActiveWindow in Win32API
declare integer GetWindow in Win32API ;
	integer lnhWnd, integer wCmd
declare integer GetClassName in Win32API ;
	integer lnhWnd, string @lpClassName, integer lnMaxCount
declare integer GetWindowText in Win32API ;
	integer lnhWnd, string lpString, integer cCH

* If a window name wasn't passed, use _screen.Caption.

lcWindowName = iif(vartype(tcWindowName) = 'C' and not empty(tcWindowName), ;
	tcWindowName, _screen.Caption) 
lnFoxHWnd    = GetActiveWindow()
lnHWndNext   = GetWindow(lnFoxHWnd, GW_HWNDFIRST)

* Get our window class name.

*** This code is commented out so we don't care about class, only window name.
***lnBuffer   = 200
***lcBuffer   = space(lnBuffer)
***lnBuffer   = GetClassName(lnFoxHWnd, @lcBuffer, lnBuffer)
***lcOurClass = left(lcBuffer, lnBuffer - 1)

* Check each window for the specified title. Skip this application's window and
* any child windows. If we find one, return its hWnd.

do while lnHWndNext <> 0
	if lnHWndNext <> lnFoxHWnd and GetWindow(lnHWndNext, GW_OWNER) = 0
		lcTitle = space(cnWINDOW_TITLE_LEN)
		GetWindowText(lnHWndNext, @lcTitle, cnWINDOW_TITLE_LEN)
		lcTitle = alltrim(strtran(lcTitle, chr(0)))
		if (lcWindowName $ lcTitle and not tlExactName) or ;
			(lcWindowName == lcTitle and tlExactName)
			exit
*** This code is commented out so we don't care about class, only window name.
***			lnBuffer = 200
***			lcBuffer = space(lnBuffer)
***			lnBuffer = GetClassName(lnHWndNext, @lcBuffer, lnBuffer)
***			lcClass  = left(lcBuffer, lnBuffer - 1)
***			if lcClass == lcOurClass
***				exit
***			endif lcClass == lcOurClass
		endif (lcWindowName $ lcTitle ...
	endif lnHWndNext <> lnFoxHWnd ...
	lnHWndNext = GetWindow(lnHWndNext, GW_HWNDNEXT)
enddo while lnHWndNext <> 0
return lnHWndNext
