#define clUSE_XML .F.
	&& set to .T. to persist as XML instead of fields in table

* Create a cursor with the desired structure.

if not clUSE_XML
	create cursor TEST (FILENAME V(40), CONNTYPE N(1), TEST L, STATUS C(1), ;
		TESTARRAY M)
endif not clUSE_XML

* Create a test object and set some properties.

loTest = newobject('Test', 'Test.vcx')
with loTest
	.cFileName   = 'test.txt'
	.lTest       = .T.
	.nTest       = 2	&& not persisted
	.nConnection = 1
	.cStatus     = 'V'
	dimension .aTest[2, 2]
	.aTest[1, 1] = 'a1'
	.aTest[1, 2] = 'a2'
	.aTest[2, 1] = 'b1'
	.aTest[2, 2] = 'b2'
endwith

* Create a persistence object and have it create the storage object for us.

loPersist = newobject('SFPersistObject', 'SFPersist.vcx')
if clUSE_XML
	lcXML = loPersist.SaveToXML(loTest, 'testxml')
	messagebox(lcXML)
else
	loStorage = loPersist.SaveToObject(loTest)
	insert into TEST from name loStorage
	browse
endif clUSE_XML

* Now do the opposite: create a new test object and restore its properties.

loTest = newobject('Test', 'Test.vcx')
if clUSE_XML
	loPersist.RestoreFromXML(loTest, lcXML)
else
	scatter memo name loStorage
	loPersist.RestoreFromObject(loTest, loStorage)
endif clUSE_XML
lcMessage = ''
lcMessage = UpdateMessage(lcMessage, loTest, 'cFileName')
lcMessage = UpdateMessage(lcMessage, loTest, 'lTest')
lcMessage = UpdateMessage(lcMessage, loTest, 'nTest')	&& not persisted
lcMessage = UpdateMessage(lcMessage, loTest, 'nConnection')
lcMessage = UpdateMessage(lcMessage, loTest, 'cStatus')
lcMessage = UpdateMessage(lcMessage, loTest, 'aTest[1, 1]')
lcMessage = UpdateMessage(lcMessage, loTest, 'aTest[1, 2]')
lcMessage = UpdateMessage(lcMessage, loTest, 'aTest[2, 1]')
lcMessage = UpdateMessage(lcMessage, loTest, 'aTest[2, 2]')
messagebox(lcMessage)

function UpdateMessage(tcMessage, toObject, tcProperty)
return tcMessage + iif(empty(tcMessage), '', chr(13)) + ;
	tcProperty + ' = ' + transform(evaluate('toObject.' + tcProperty))
