*==============================================================================
* Program:				WHICHONE.PRG
* Purpose:				Which one of the files throws an error when building?
* Author:				Ted Roche
* Modifications:		Barbara Peisch
* Copyright:			(c) 2002
* Last revision:		08/01/02
*==============================================================================
#INCLUDE "FoxPro.H"
LOCAL lcCurDir, lcHomeDir, lcOldOnError, lcLastCompile, llError
lcCurDir = SYS(5)+CURDIR()

IF type('_vfp.ActiveProject.Name') <> 'C'
  MODIFY PROJECT ? nowait
  IF type('_vfp.ActiveProject.Name') <> 'C'
    MESSAGEBOX("You must have a project open!",48,"No project open")
    RETURN 
  ENDIF
ENDIF 

lcOldOnError = ON('Error')

CREATE CURSOR CompProbs (ProgramName C (50), ErrMessage C (100))

USE (_vfp.ActiveProject.Name) AGAIN IN 0 ALIAS theproject NOUPDATE
SELECT theproject
lcHomeDir = ADDBS(ALLTRIM(theproject.HomeDir))
CD (lcHomeDir)
SELECT PADR(ALLTRIM(name),128) as cName, ;
  type as cType;
  FROM theproject ;
  WHERE type in (FILETYPE_DATABASE , ;
  FILETYPE_FORM, ;
  FILETYPE_REPORT, ;
  FILETYPE_LABEL, ;
  FILETYPE_CLASSLIB) ;
  INTO CURSOR filelist readwrite
SELECT filelist
USE IN theproject
SCAN
  lcLastCompile = cName
  llError = .F.
  ON ERROR llError = .T.

  WAIT WINDOW NOWAIT "Compiling "+cName
  DO case
    CASE cType = FILETYPE_DATABASE
      COMPILE DATABASE (cName)
    CASE cType = FILETYPE_FORM
      COMPILE FORM (cName)
    CASE cType = FILETYPE_REPORT OR cType = FILETYPE_LABEL
      COMPILE REPORT (cName)
    CASE cType = FILETYPE_CLASSLIB
      * Clear the classlibrary from memory, first
      CLEAR CLASSLIB (cName)
      COMPILE CLASSLIB (cName)
    OTHERWISE
      * No action - not compilable
  ENDCASE
  WAIT CLEAR 
  
  ON ERROR &lcOldOnError
  IF llError
    INSERT INTO CompProbs VALUES (lcLastCompile, MESSAGE())
  ENDIF 
ENDSCAN

SELECT CompProbs
IF RECCOUNT() > 0
  ACTIVATE SCREEN 
  BROWSE LAST 
ELSE
  MESSAGEBOX("No problems found during compile",64,"Success!")
ENDIF 

USE IN CompProbs
USE IN filelist
CD (lcCurDir)
