DEFINE CLASS BlogRetriever As Session OLEPUBLIC
	PROCEDURE Init
		** This assumes vfpconnection.fll is
		** located in your path by the DLL!
		SET LIBRARY TO vfpconnection.fll
	ENDPROC
	
	PROCEDURE Destroy
		** Release the fll
		SET LIBRARY TO
	ENDPROC	

	PROCEDURE GetBlogs(toCallback)
	
		** This function calls the web server and 
		** returns a string to be parsed by the 
		** callback object. 
		
		LOCAL lcHTTP As String, lcList As String
		lcHTTP = HTTPToStr("www.kevinragsdale.net/FoxBlogs.aspx")
		lcList = STREXTRACT(lcHTTP,[<h2>Subscriptions</h2>],[</ul>],1)
		
		** toCallback is the form. It contains a method
		** named ProcessBlogs which will parse this result.	
		IF VARTYPE(m.toCallback) == "O"
			TRY
				toCallback.ProcessBlogs(m.lcList)
			CATCH
			ENDTRY
		ENDIF	
	ENDPROC	
	
	PROCEDURE GetAuthor(toCallback)
		LOCAL lcHTTP As String, lcURL As String, llContinue As Boolean
		lcHTTP = ""
		lcURL = ""
		llContinue = .T.
		
		IF VARTYPE(m.toCallback) == "O"
			TRY
				m.lcURL = m.toCallback.cURL
			CATCH
				m.llContinue = .F.
			ENDTRY	
		ELSE
			m.llContinue = .F.
		ENDIF
			
		IF m.llContinue
			m.lcHTTP = HTTPToStr(m.lcURL)
		ENDIF

		** toCallback is a custom object with a 
		** method named ProcessResult which will
		** parse this result.
		IF VARTYPE(m.toCallback) == "O"
			TRY
				m.toCallback.ProcessResult(m.lcHTTP)
			CATCH
			ENDTRY
		ENDIF
	ENDPROC	
ENDDEFINE	