***********************************************************************
* Program....: WRAPPER.PRG
* Author.....: Andy Kramek
* Date.......: 14 July 2002
* Notice.....: Copyright (c) 2002 Tightline Computers Inc
* Compiler...: Visual FoxPro 08.00.0000.1807 for Windows 
* Purpose....: Example of a class that implements a wrapper pattern
***********************************************************************

DEFINE CLASS oAPIWrap AS SESSION
  cxnLibs = NULL
 
  ********************************************************************
  *** [E] INIT(): Create Collection on initialization
  ********************************************************************
  FUNCTION Init()
    WITH This
      RETURN .SetUpObj()
    ENDWITH
  ENDFUNC

  ********************************************************************
  *** [E] OPENKEY(): Open the specified registry key and return the handle
  ********************************************************************
  FUNCTION OpenKey( tnParent, tcKeyName )
  LOCAL lnHandle, llOK
    WITH This
      *** Declare the API call if not already declared
      llOK = .CheckFunc( "RegOpenKeyEx" )
      *** Couldn't open the API Function
      IF NOT llOK
        RETURN 0
      ENDIF
      IF VARTYPE( tnParent ) # "N" OR EMPTY( tnParent )
        *** Default to HKEY_CURRENT_USER
        tnParent = -2147483647  && BITSET(0,31)+1
      ENDIF
      *** Now Call the API Function
      lnHandle = 0
      RegOpenKeyEx( tnParent, tcKeyName, 0, 1, @lnHandle )
      *** And return the result
      RETURN lnHandle
    ENDWITH
  ENDFUNC

  ********************************************************************
  *** [E] CLOSEKEY(): Close the specified registry key
  ********************************************************************
  FUNCTION CloseKey( tnHandle )
    LOCAL llOk, lnRes
    WITH This
      IF VARTYPE( tnHandle ) # "N" OR EMPTY( tnHandle )
        *** Must pass a key
        RETURN .F.
      ENDIF
      *** Declare the API call if not already declared
      llOK = .CheckFunc( "RegCloseKey" )
      *** Couldn't open the API Function
      IF NOT llOK
        RETURN .F.
      ENDIF
      lnRes = RegCloseKey( tnHandle )
      RETURN (lnRes = 0)
    ENDWITH
  ENDFUNC

  ********************************************************************
  *** [P] CHECKFUNC(): Encure Function is declared, and declare it if not
  ********************************************************************
  PROTECTED FUNCTION CheckFunc( tcFuncName )
  LOCAL llRetVal
    WITH This
      IF .cxnLibs.Count > 0
        *** Check the collection
        IF VERSION(5) > 799
          *** VFP 8.0
          FOR EACH lcLib IN .cxnLibs
            IF UPPER( ALLTRIM( lcLib )) == UPPER( ALLTRIM( tcFuncName ))
              llRetVal = .T.
              EXIT
            ENDIF
          NEXT
        ELSE
          *** VFP 7.0
          lnFound = .cxnLibs.FindItem( tcFuncName )
          llRetVal = (lnFound > 0 )
        ENDIF
      ELSE
        *** Have we got it in the table then?
        IF SEEK( UPPER( ALLTRIM( tcFuncName )), "apicalls", "cfuncname" )
          *** Run the declaration
          EXECSCRIPT( apicalls.mdeclare )
          llRetVal = .T.
        ELSE
          *** Return Error
          llRetVal = .F.      
        ENDIF
      ENDIF
      *** Return the status
      RETURN llRetVal 
    ENDWITH
  ENDFUNC

  ********************************************************************
  *** [P] SETUPOBJ(): Set up collection and tables
  ********************************************************************
  PROTECTED FUNCTION SetUpObj()
    WITH This
      *** Set up the collection object
      IF VERSION(5) > 799
        *** VFP 8.0
        .cxnLibs = NEWOBJECT( 'collection' )
      ELSE
        *** VFP 7.0
        .cxnLibs = NEWOBJECT( 'ClxItem', 'collection.prg' )
      ENDIF
      *** And populate it
      lnDex = ADLLS( laDex )
      IF lnDex > 0
        *** We have some declarations
        FOR lnCnt = 1 TO lnDex
          *** Load the ALIAS for any functions that 
          *** have already been declared (Element 2)
          .cxnLibs.Add(lADex[lnCnt, 2])
        NEXT
      ENDIF  
      *** Now try and open the reference table
      llRetVal = FILE( 'apicalls.dbf' )
      IF llRetVal
        IF NOT USED( 'apicalls' )
          *** Open the table and index on functions
          USE apicalls IN 0 ORDER 1
        ENDIF
      ENDIF  
      *** Return Status
      RETURN USED( 'apicalls' )
    ENDWITH
  ENDFUNC
 
ENDDEFINE

