********************************************************************
*** Name.....: FACTORY.PRG
*** Author...: Andy Kramek & Marcia Akins
*** Date.....: 19/10/2004
*** Notice...: Copyright (c) 2004 Tightline Computers, Inc
*** Compiler.: Visual FoxPro 09.00.0000.2124 for Windows 
*** Parameters: keyword from classes table to look up class info and up to 4 optional parameters
*** Returns..: Object Reference
*****************************************************************************************

DEFINE CLASS factory AS Session
*** Give it a private data session so we can set exact ON
*** so we can accurately use a SEEK into the classes table
DataSession = 2

******************************************************
FUNCTION Init()
**********************************************

*** This is a private data session so just force exact ON
SET EXACT ON
*** Open the classes table	
IF NOT USED( 'ClasFact' )
	USE ClasFact AGAIN IN 0
ENDIF

ENDFUNC
	
****************************************************************************
FUNCTION New( tcKey, tuParam1, tuParam2, tuParam3, tuParam4, tuParam5 )
*****************************************************************************
LOCAL lcLibType, lcCommand, lnParm, lnParmCount, loObject, llFound, lcKey, lnSelect, llCreate, lcProperties
LOCAL lcLibrary, lcClassName

*** Make sure we got a keyword
IF EMPTY( tcKey )
	RETURN .NULL.
ENDIF

*** Get the class information
lcKey = UPPER( ALLTRIM( tcKey ) )

*** Check the classes table 
SELECT ClasFact
llFound = SEEK( lcKey, 'ClasFact', 'cKey' )
		
IF NOT llFound
	*** Make sure keyword was found in ClasFact table
	RETURN .NULL.
ENDIF

*** Save pertinent info and force to upper case
lcProperties = ALLTRIM( mprops )		
lcLibrary = UPPER( ALLTRIM( cLibrary ) )
lcClassName = UPPER( ALLTRIM( cClassName ) )

*** Is this class in a vcx or a prg?
lcLibType = This.ChkLibType( lcLibrary )
		
*** Make sure our class library has an extension
*** Just in case one was not specified in Classes.dbf
IF EMPTY( lcLibType ) 
	RETURN .NULL.
ELSE
	lcLibrary = FORCEEXT( lcLibrary, lcLibType )
ENDIF

*** Now, see if our prg or vcx has been set 
IF lcLibType = 'PRG'
	llCreate = ( lcLibrary $ SET( 'PROCEDURE' ) ) OR ;
		( FORCEEXT( lcLibrary, 'FXP' ) $ SET( 'PROCEDURE' ) )	
ELSE
	llCreate = lcLibrary $ SET( 'CLASSLIB' )
ENDIF

IF llCreate
	lcCommand = 'CreateObject( "' + lcClassName + '"'
ELSE
	lcCommand = 'NewObject( "' + lcClassName + '", "' + lcLibrary + '"'
ENDIF

*** Now tack the parameters on to the end of the command
*** if any were passed	
lnParmCount = PCOUNT() - 1
IF  lnParmCount > 0
	*** Only add the third parameter if we are using NewObject
	IF NOT llCreate
		lcCommand = lcCommand + ', ""'
	ENDIF
	FOR lnParm = 1 TO  lnParmCount
		lcCommand = lcCommand + ', tuParam' + TRANSFORM( lnParm )
	ENDFOR
ENDIF
lcCommand = lcCommand + ' )'

*** Go ahead and instantiate the object
loObject = &lcCommand

*** Now see if we have some properties to set
IF NOT EMPTY( lcProperties )
	*** First make sure we have an object
	IF VARTYPE( loObject ) = 'O'
		This.GetProperties( loObject, lcProperties )
	ENDIF
ENDIF

RETURN loObject
					
ENDFUNC

*****************************************************************************
PROTECTED FUNCTION GetProperties( toObject, tcProperties )
*****************************************************************************
LOCAL lnTotal, laProps[ 1 ], lnCnt, lcPropName, lcPropValue, lcType, loItem, luValue

*** get all the attribute/value pairs in the memo field into a single array element
lnTotal = ALINES( laProps, tcProperties )	
*** And process each pair in the array
FOR lnCnt = 1 TO lnTotal
	*** Get the name of the property
	lcPropName = ALLTRIM( GETWORDNUM( laProps[ lnCnt ], 1, '=' ) )
	lcPropValue = ALLTRIM( GETWORDNUM( laProps[ lnCnt ], 2, '=' ) ) 
	*** Make sure it is a property on the object
	IF PEMSTATUS( toObject, lcPropName, 5 )
		*** See if we can get its data type
		loItem = 'toObject.' + lcPropName
		lcType = TYPE( loItem )
		*** Now get back the value in the appropriate data type
		luValue = This.Str2Exp( lcPropValue, lcType )
		&loItem = luValue		
	ENDIF
ENDFOR

********************************************************************************
PROTECTED FUNCTION Str2Exp( tcExp, tcType )
********************************************************************************
LOCAL lcExp, luRetVal, lcType, lcStr

*** Verify parameters
IF VARTYPE( tcExp ) # 'C'
	ASSERT .F. MESSAGE TRANSFORM( tcExp ) + ' is NOT a character expression and you MUST pass a character expression to Str2Exp!'
	RETURN tcExp
ENDIF
IF EMPTY( tcType )
	ASSERT .F. MESSAGE 'You MUST pass a data type to Str2Exp!'
	RETURN tcExp
ENDIF

*** If no type passed -- map to expression type
lcType = UPPER( ALLTRIM( tcType ) )
*** Remove any NULL characters, and leading/trailing spaces
lcExp = CHRTRAN( ALLTRIM( tcExp ), CHR( 0 ), '' )
*** Convert from Character to the correct type
DO CASE
  *** Integers
  CASE INLIST( lcType, 'I', 'N' ) AND INT( VAL( lcExp ) ) == VAL( lcExp ) 
    luRetVal = INT( VAL( lcExp ) )
  *** Other Numeric 
  CASE INLIST( lcType, 'N', 'B' )
    luRetVal = VAL( lcExp )
  *** Currency
  CASE lcType = "Y"
    luRetVal = NTOM( VAL( lcExp ))
  *** Character or memo
  CASE INLIST( lcType, 'C', 'M' ) 
    *** Remove delimiting marks if present.
    IF INLIST( LEFT(lcExp,1), CHR(91), CHR(34), CHR(39))
      *** We begin with a delimiter
      lcExp = SUBSTR( lcExp, 2 )
      *** So we should end with a delimiter
      IF INLIST( RIGHT(lcExp,1), CHR(93), CHR(34), CHR(39))
        lcExp = LEFT( lcExp, LEN( lcExp )- 1 )
      ENDIF
    ENDIF
    luRetVal = lcExp
  *** Logical
  CASE lcType = 'L'
    luRetVal = IIF( !EMPTY( CHRTRAN( lcExp, 'Ff0.', "" ) ), .T., .F.)
  *** Date
  CASE lcType = 'D' && Date
    *** Check for separators in the string
    IF CHRTRAN( lcExp, "/.-", "" ) == lcExp
      *** We are in yyyymmdd format
      lcStr = LEFT( lcExp, 4) + "," + SUBSTR( lcExp, 5, 2 ) + "," + RIGHT( lcExp, 2)
      luRetVal = DATE( &lcStr )
    ELSE
      *** We are in DTOC() format
      luRetVal = CTOD( lcExp )
    ENDIF
  *** DateTime
  CASE lcType = 'T' && DateTime 
    *** Check for date separators in the string
    IF CHRTRAN( lcExp, "/.-", "" ) == lcExp
      *** No separators so we have something other than TTOC() format
      IF LEN( lcExp ) > 8
        *** This one must be in yyyymmddhhmmss format
        *** So get the date part first
        lcStr = LEFT( lcExp, 4) + "," + SUBSTR( lcExp, 5, 2 ) + "," + SUBSTR( lcExp, 7, 2)
        *** and convert to the correct date string format
        lcStr = DTOC( DATE( &lcStr ))
        *** Now tack on the hours part
        lcStr = lcStr + " " + SUBSTR( lcExp, 9, 2 )
        *** Minutes
        IF LEN( lcExp ) > 10
          lcStr = lcStr + ":" + SUBSTR( lcExp, 11, 2 )
        ELSE
          lcStr = lcStr + ":00"
        ENDIF
        *** Seconds
        IF LEN( lcExp ) > 12
          lcStr = lcStr + ":" + SUBSTR( lcExp, 13, 2 )
        ELSE
          lcStr = lcStr + ":00"
        ENDIF
        luRetVal = CTOT( lcStr )
      ELSE  
        *** This must be a date in yyyymmdd format which we want to force to DateTime format
        lcStr = LEFT( lcExp, 4) + "," + SUBSTR( lcExp, 5, 2 ) + "," + RIGHT( lcExp, 2)
        luRetVal = DTOT( DATE( &lcStr )) 
      ENDIF
    ELSE
      *** We are already in TTOC() format
      luRetVal = CTOT( lcExp )
    ENDIF

  OTHERWISE
    *** We have an invalid combination of value and data type
    MESSAGEBOX( "Cannot convert " + lcExp + " to Data Type " + tcType, 16, "Conversion Failed " )
    luRetVal = lcExp
ENDCASE
*** Return value as Data Type
RETURN luRetVal

*****************************************************************************
PROTECTED FUNCTION ChkLibType( tcLibrary )
*****************************************************************************
LOCAL lcLibType

*** Checks for file extension on library name, and
*** figures out what it should be if not supplied
lcLibType = UPPER( JUSTEXT( tcLibrary ) )

IF NOT EMPTY( lcLibType ) 
	lcLibType = IIF( FILE( tcLibrary ), lcLibType, '' )
ELSE
	*** See if we have a vcx here
	lcLibType = IIF( FILE( FORCEEXT( tcLibrary,'VCX' ) ), 'VCX', '' )
	IF EMPTY ( lcLibType )
		lcLibType = IIF( FILE( FORCEEXT( tcLibrary,'PRG' ) ), 'PRG', '' )
	ENDIF
ENDIF		
		
RETURN lcLibType

ENDDEFINE


