***********************************************************************
* Program....: COLLECTION.PRG
* Author.....: Andy Kramek
* Date.......: 04 August 2002
* Notice.....: Copyright (c) 2002 Tightline Computers Ltd, All Rights Reserved
* Compiler...: Visual FoxPro 07.00.0000.9465
* Purpose....: VFP Collection Class Definitions
***********************************************************************

********************************************************************
***              COLLECTION ITEM CLASS DEFINITION                ***
********************************************************************
DEFINE CLASS ClxItem AS Session
  *** Properties Required
  Count = 0
  DECLARE Item[1]

  ********************************************************************
  *** [E] INIT(): Standard Initialization method
  ********************************************************************
  FUNCTION Init()
	  This.Item[1] = null
  ENDfUNC

  ********************************************************************
  *** [E] ADD(): Add an item to the collection
  ********************************************************************
  FUNCTION Add( tuItem )
	LOCAL lnRow
  	WITH This
      *** Determine the next row number and increase the array dimensions
  		lnRow = .Count + 1
  		DIMENSION .Item[lnRow]
  		*** And add the item
  		.Item[lnRow] = tuItem
      *** Just return whatever we got	sent
    	RETURN tuItem
    ENDWITH
  ENDFUNC

  ********************************************************************
  *** [E] REMOVE(): Remove an item from the collection
  ********************************************************************
  FUNCTION Remove( tuIndex )
  LOCAL lnRow, lnCount
    WITH This
      lnRow = .FindItem( tuIndex )    
      IF lnRow > 0
        *** Make sure the item is NULL and delete it
        .Item[ lnRow ] = null
        ADEL( .Item, lnRow )
        *** Update the count property
        lnCount = .Count
        DIMENSION .Item[ IIF( lnCount > 0, lnCount, 1)]
      ELSE
        *** We can't find the item, so do nothing here
      ENDIF
    ENDWITH
  ENDFUNC

  ********************************************************************
  *** [E] COUNT_ACCESS(): Access method for the Count Property
  ********************************************************************
  FUNCTION Count_Access
  LOCAL lnMembers
  	WITH This
      *** Get rid of any items that are NULL or Empty
      .CleanItems()
    	lnMembers = ALEN( .Item, 1 )
    	*** Set the count property correctly
    	.Count = IIF( lnMembers = 1 AND ISNULL( .Item[1]), 0, lnMembers )	
    	RETURN .Count
    ENDWITH
  ENDFUNC 

  ********************************************************************
  *** [E] ITEM_ACCESS(): Access method for the Item Array
  ********************************************************************
  FUNCTION Item_Access( tuIndex )
  LOCAL luItem, lnRow
  	WITH This
      *** What type of index did we get
      lnRow = IIF( VARTYPE( tuIndex ) $ 'NIFBY' AND NOT EMPTY( tuIndex ), tuIndex, ;
                IIF( VARTYPE( tuIndex ) = "C" AND NOT EMPTY( tuIndex ), .FindItem( tuIndex ), 0 ))
      luItem = IIF( lnRow > 0, .Item[ lnRow ], NULL )
      *** Return whatever we got  
      RETURN luItem
  	ENDWITH
  ENDFUNC

  ********************************************************************
  *** [P] FINDITEM(): Return row number to the specified item
  ********************************************************************
  FUNCTION FindItem( tuIndex )
  LOCAL lnRow
    WITH This
      lnRow = ASCAN( .Item, tuIndex, -1, -1, 1, 15 )
      RETURN lnRow
    ENDWITH
  ENDFUNC

  ********************************************************************
  *** [P] CLEANITEMS(): Remove Null/Empty items and re-dimesions the collection
  ********************************************************************
  PROTECTED FUNCTION CleanItems()
  LOCAL lnRow, lnItems
    WITH This
      DO WHILE .T.
        *** Check for nulls first
        lnRow = ASCAN( .Item, NULL)
        IF lnRow > 0
          *** Delete the row
          ADEL( .Item, lnRow )
          LOOP
        ELSE
          *** No Nulls, so go for deleted rows
          lnRow = ASCAN(.Item, .F.)
          IF lnRow = 0
            *** No more deleted rows, so exit
            EXIT
          ENDIF
        ENDIF
        *** Remove deleted rows here
        *** How many items
        lnItems = ALEN( .Item, 1 )
        IF lnItems = 1
          *** We only have one row and, because we are here, 
          *** it must be empty, so just set to NULL
          DIMENSION .Item[1]
          .Item[1] = NULL
          EXIT
        ELSE
          *** Decrement the row count
          lnItems = IIF( (lnItems - 1) > 0, lnItems - 1, 1 )                  
          DIMENSION .Item[ lnItems ]
        ENDIF
      ENDDO
    ENDWITH
  ENDFUNC

ENDDEFINE 

