*
*
*    PLIB.PRG -- procedure library
*
*
*------------------------------------------------------------------------------
*
*
     FUNCTION STARTUP( lx1, ;
                       lx2, ;
                       lx3, ;
                       lx4, ;
                       lx5 )
*
*   Routine, run every time stuff...
*    
ON ERROR =LOGERRORS( Error(),    ; && Error number
                     Message(),  ; && Error message
                     Message(1), ; && Source statement    
                     LineNo()   )  && Line number

SET CONSOLE OFF
SET ODOMETER TO 100 && default value
SET SAFETY OFF
SET TALK OFF

=StartLog()

RETURN .T. && leave StartUp()
*------------------------------------------------------------------------------
*
*
     Function STARTLOG( lx1, ;
                        lx2, ;
                        lx3, ;
                        lx4, ;
                        lx5 )
*
*    Create missing log, generate log header 
*
LOCAL               ;
   lcString,        ;
   ;
   lnAlenErrorsExe, ;
   lnPadWidth
 
lnPadWidth = 80
 
LOCAL ;
	ARRAY laErrorsExe[01,05]   
	
IF FILE( "Errorlog.txt" )

   lcString = FILETOSTR( "ErrorLog.txt" )

else

   lcString = ""

endif

lcString = lcString + lcCrLf
lcString = lcString + ;
           PADC( SPACE(1) + datelinef() + SPACE(1), lnPadWidth, "^" ) + ;
           lcCrLf
lcString = lcString + PADC( "( LA Fox Jump Start )", ;
                            lnPadWidth, ;
                            SPACE(1) ) + ;
                      lcCrLf
lcString = lcString + PADC( "Libraries: " + VERSION(4), ;
                            lnPadWidth, ;
                            SPACE(1) ) + ;
                      lcCrLf
lnAlenErrorsExe = ADIR( laErrorsExe, "Errors.exe" )

IF lnAlenErrorsExe > 0

   lcString = lcString + ;
              PADC( ADDBS( SYS(5) + SYS(2003) ) + "Errors.exe", ;
                    lnPadWidth, ;
                    SPACE(1) ) + ;
              lcCrLf
   lcString = lcString + ;
              PADC( ALLTRIM( TRANSFORM( laErrorsExe[01,02], "999,999,999" ) + ;
                    " bytes, as of " + ;
                    DTOC( laErrorsExe[01,03] ) + SPACE(1) + laErrorsExe[01,04] ), ;
                    lnPadWidth, ;
                    SPACE(1) ) + ;
              lcCrLf

endif

lcString = lcString + PADC( "( registered contact name )", ;
                            lnPadWidth, ;
                            SPACE(1) ) + ;
                      lcCrLf
lcString = lcString + PADC( "( registered phone number )", ;
                            lnPadWidth, ;
                            SPACE(1) ) + ;
                      lcCrLf
lcString = lcString + PADC( "( registered email address )", ;
                            lnPadWidth, ;
                            SPACE(1) ) + ;
                      lcCrLf
lcString = lcString + lcCrLf
=Logit( lcString )

RETURN .T. && leave StartLog()
*------------------------------------------------------------------------------
*
*
     Function Generate_Error()
*
*   Generate an error
*
Skunks stink && comment on source statement

Return .T. && leave Generate_Error()
*------------------------------------------------------------------------------
*
*
     Function LOGERRORS( lx1, ;
                         lx2, ;
                         lx3, ;
                         lx4, ;
                         lx5, ; &&  5 and 6 are dummy parameters...
                         lx6 )
*
*    Format display of error #, message, line #, stack call back, etc.
*  
Local           ;  
   lcMarker,    ;
   lcMessage,   ;
   lcMessage1,  ;
   lcProgram,   ;  
   lcString,    ;
   ;
   lnError,     ;
   lnForNext,   ;
   lnLimit,     ;
   lnLineNo,    ;
   lnVersion

LOCAL ;
   ARRAY laStack[01,06]

DO case

   CASE PCOUNT() = 4 && ON ERROR...
   
        lnError    = lx1
        lcMessage  = lx2
        lnLineNo   = lx4
        lcProgram  = Program( Program( -1 ) -2 )
        
   CASE PCOUNT() = 3 && Error() method from a form, etc.
   
        lnError    = lx1
        lcMessage  = MESSAGE()
        lnLineNo   = lx3
        lcProgram  = UPPER( lx2 )
   
   OTHERWISE 

        lnError    = -1
        lcMessage  = "Unknown error"
        lnLineNo   = 0
        lcProgram  = "Unknown"

ENDCASE

lnVersion = VERSION(5) && numeric major release only
lcMessage1 = ""

IF lnVersion > 699

   lcCommand = "lnLimit = ASTACKINFO( laStack )"
   &lcCommand && hide AStackInfo() from VFP 6

   FOR lnForNext = 1 TO lnLimit STEP 1
         
      ***06/21/02***=MESSAGEBOX( ;
                   UPPER( laStack[lnForNext,03] ) + CHR(13) + ;
                   lcProgram, ;
                   64,;
                   "Are strings equal ?" )
   
      IF laStack[lnForNext,05] = lnLineNo .and. ;
         UPPER( laStack[lnForNext,03] ) = lcProgram
         
         lcMessage1 = laStack[lnForNext,06]
         EXIT && leave For / Next
         
      endif
   
   NEXT lnForNext
 
ELSE

   lnLimit = 0 
 
endif

IF EMPTY( lcMessage1 )

   lcMessage1 = IIF( PCOUNT() = 3, ;
                     MESSAGE(1), ;
                     IIF( PCOUNT() = 4, ;
                          lx3, ;
                          "" ) )	

endif
   
lcMarker = "[Error] " && mark each line of errors in the log
lcString = ""

lcString = lcString + ;
           lcMarker + ;
           lcCRLF

IF lnVersion > 699

   lcString = lcString + ;
              lcMarker + ;
              "Machine # Userid = " + ;
              sys(0) + ;
              lcCRLF
   lcString = lcString + ;
              lcMarker + ;
              "OS = " + ;
              OS(1) + ;
              ", " + ;
              OS(7) + ;
              lcCRLF
              
ELSE

   lcString = lcString + ;
              lcMarker + ;
              "Machine # Userid # OS = " + ;
              sys(0) + ;
              " # " + ;
              OS() + ;
              lcCRLF

ENDIF

if VarType( lnError ) = "N"

   lcString = lcString + ;
              lcMarker + ;
              "Error # " + ;
              alltrim( str( lnError ) ) + ;
              IIF( VarType( lcMessage ) = "C", ;
                   " -- " + lcMessage, ;
                   "" ) + ;
              lcCRLF

endif   

if VarType( lcMessage1 ) = "C" .and. ;
   VarType( lcMessage ) = "C" .and. ;
   lcMessage # lcMessage1

   lcString = lcString   + ;
              lcMarker   + ;
              lcMessage1 + ; && source code
              lcCRLF

endif

if VarType( lnLineNo ) = "N"

   lcString = lcString + ;
              lcMarker + ;
              "Line number " + ;
              alltrim( transform( lnLineNo, ;
                                  "999,999,999" ) ) + ;
              " in " + ;
              lcProgram + ;
              lcCRLF                                                 

endif

lcString = lcString + ;
           lcMarker + ;
           lcCRLF

IF lnVersion > 699 && aStackInfo() added in version 7

   lcString = lcString + ;
              lcMarker + ;
              " Line #    Source file / line contents" + ;
              lcCRLF 
              
   FOR lnForNext = ( lnLimit - 1 ) TO 1 step -1
   
       lcString = lcString + ;
                  lcMarker + ;
                  TRANSFORM( laStack[lnForNext,05], "999,999" ) + ;
                  SPACE(4) + ; 
                  laStack[lnForNext,04] + ;
                  lcCRLF
       lcString = lcString + ;
                  lcMarker + ;
                  SPACE(11) + ;
                  laStack[lnForNext,06] + ;
                  lcCRLF
   
   NEXT lnForNext
   
else

   lnLimit = Program( -1 )

   if lnLimit > 2

      for lnForNext = 1 to lnLimit -1 

         lcString = lcString + ;
                    lcMarker + ;
                    SYS( 16, lnLimit - lnForNext ) + ;
                    lcCRLF

      next lnForNext

   endif

endif

lcString = lcString + ; && separate this group of messages from all others...
           lcMarker + ;
           Replicate( "-", ;
                      40 ) + ;
           lcCRLF

=Logit( lcString )

IF TYPE( "_Screen.nCountofErrors" ) # "N" .and. ;
   TYPE( "_Screen" ) = "O"

   ***06/21/02***
   _Screen.AddProperty( "nCountOfErrors", 0 ) && limit runaway errors

endif

IF TYPE( "_Screen.nLimitofErrors" ) # "N" .and. ;
   TYPE( "_Screen" ) = "O"

   _Screen.AddProperty( "nLimitOfErrors", ;
                        500 ) && ONLY 5 for the demo  
   
endif

IF TYPE( "_Screen.nCountofErrors" ) = "N"

   _Screen.nCountOfErrors = _Screen.nCountOfErrors + 1

ENDIF

=MESSAGEBOX( "Error # " + ;
             ALLTRIM( STR( lnError ) ) + ;
             " -- " + ;
             lcMessage + ;
             CHR(13) + ;
             "at Line # " + ;
             ALLTRIM( STR( lnLineNo ) ) + ;
             " of " + ;
             lcProgram + ;
             IIF( lcMessage # lcMessage1, ;
                  CHR(13) + lcMessage1, ;
                  "" ), ;
             64, ;
             "Error" + ;
             IIF( VARTYPE( _Screen.nCountofErrors ) = "N", ;
                  " count = " + ;
                  ALLTRIM( STR( _Screen.nCountOfErrors ) ), ;
                  "" ) )

IF TYPE( "_Screen.nCountofErrors" ) = "N" .and. ;
   TYPE( "_Screen.nLimitofErrors" ) = "N" .and. ;
   TYPE( "_Screen" ) = "O"

   IF _Screen.nCountOfErrors >= _Screen.nLimitofErrors
   
      =MESSAGEBOX( "At least " + ;
                   ALLTRIM( STR( _Screen.nLimitofErrors ) ) + ;
                   " errors have occurred" + ;
                   CHR(13) + ;
                   "We cannot continue to run the application" + ;
                   CHR(13) + ;
                   CHR(13) + ;
                   "Notify your system administrator / software support", ;
                   16, ;
                   "Fatal Error" )                   

      QUIT
   
   endif

endif

Return .T. && leave LogErrors()    
*------------------------------------------------------------------------------
*
*
     Function LOGIT( lcMessage, ;
                     lx2,       ; && dummy parameters
                     lx3,       ;
                     lx4,       ;
                     lx5       )
*
*   Record message into log file
*
Local        ;
   lcString
   
lcString = ""
   
if VarType( lcMessage ) = "C"

   lcString = lcString + lcMessage + iif( right( lcMessage, ;
                                                 2 ) # lcCRLF, ;
                                          lcCRLF, ;
                                          "" )

endif

strtofile( lcString,       ;
           "ERRORLOG.TXT", ;
           .T. )             && append to end of string     

RETURN .T. && leave LOGIT()
*------------------------------------------------------------------------------
*
*
     Function AssertMessage( lc1, ;
                             lc2, ;
                             lx3, ; && dummy parameters...
                             lx4, ;
                             lx5 )
*
*
*    Add minimalist calling stack to message -- good for debugging
*
*                                                      
Local        ;
   lcString
   
lcString = Program( Program( -1 ) -1 ) + ", called by " + ;
             Program( Program( -1 ) -2 ) + lcCRLF
             
do case

   case PCount() = 1 .and. ;
        VarType( lc1 ) = "C" 
   
        lcString = lcString + lc1 + lcCRLF
        
   case PCount() = 2         .and. ;
        VarType( lc1 ) = "C" .and. ;
        VarType( lc2 ) = "C"                 
        
        lcString = lcString + lc1 + lcCRLF + lc2 + lcCRLF 

endcase

Return lcString && leave AssertMessage()
*------------------------------------------------------------------------------
*
*
     Function datelinef( ldDate, ; && may be Date(), DateTime() or DTOS() format
                         lcTime, ;
                         lx3,    ;
                         lx4,    ;
                         lx5    )
*
*
*           Based upon the old reliable DATELINE.PRG
*                   (WRITTEN: AUGUST 10, 1988)
*
*     CREATES A PRINTABLE DATELINE IN THE FOLLOWING FORMAT:
*
*                 Thu, Aug 11, 1988, 11:07 am
*                 ....5....1....1....2....2.2
*                          0    5    0    5 7
*
*
*
*                The Function, unlike the program allows for
*                specifying the date and time to be used:
*
*                     ?datelinef( lddate, lctime )
*
*
*    DateLinef() is one of the oldest functions inside DTM_PLIB
*
*    05/14/98 -- most of the internal variables were not
*                declared at all, and as you can see are
*                not following the 'Hungarian' data type 
*                notation for naming standards.  Robin added
*                the 'Local' statement to at least bring
*                the routine into some measure of compliance
*                with our current standards.
*
*                Still, all-in-all, Dan Fennesy did a good job!
*
*    03/27/00 -- fully support Date, DateTime, and DTOS() formats
*                for the date parameter
*
*
Local           ;
   am_pm,       ;
   ;
   daydate,     ;
   datestring,  ;
   ;
   hr_result,   ;
   hr_value,    ;
   ;
   min_value,   ;
   myhour,      ;
   myminute,    ;
   mytime
   
assert inlist( PCount(), ;
               0,        ; && current date and time will show
               1,        ; && user passed the date()
               2       ) ; && user passed the date() and time()
       Message AssertMessage( "Expects 0 or 1 or 2 parameters, received " + ;
                              alltrim( str( PCount() ) ) )
               
DO CASE
      
   CASE PCount() = 0
      
      ldDate = DATE()
      lcTime = TIME()
      
   CASE PCount() = 1

        do case
      
           case VarType( ldDate ) = "D" && date
                *
                *   Just leave it alone, date is what we want here
                *      
                lcTime = TIME()

           case VarType( ldDate ) = "T" && DateTime -- oh boy both variables in one field...
                *
                *   DateTime() format                                                                                              111111
                *                                                                                                        1234567890123456
                lcTime = substr( TTOC( ldDate, 1 ), 09, 2 ) + ; && 09/19/00 -- TTOC( lt, 1 ) returns 24 hour value ( ccccyymmddhhmmss ), 
                           ":"                                  + ; &&             TTOC( lt, 2 ) returns formatted 12 hour value
                           substr( TTOC( ldDate, 1 ), 11, 2 ) + ; 
                           ":"                                  + ;
                           substr( TTOC( ldDate, 1 ), 13, 2 )
                ldDate = TTOD( ldDate ) && Date from DateTime expression
              
           case VarType( ldDate ) = "C"            .and. ;
                Len( ldDate ) = 8                  .and. ;
                ldDate = Str( val( ldDate ), 8 )
                *
                *   03/27/00 -- allow passing DTOS() format date
                *
                ldDate = yyyymmdddt( ldDate )
                lcTime = Time()
              
           otherwise
                *
                *   Fill in bogus value with today's date...
                *
                ldDate = DATE()
                lcTime = TIME()
   
        EndCase
            
   CASE PCount() = 2
        *
        *   If second parameter is passed, it must be character string:
        *
        *                hh:mm:ss
        *
        do case 
           
           case VarType( ldDate ) = "D"            .and. ;
                VarType( lcTime ) = "C"            .and. ;
                LEN( lcTime ) = 8                  .and. ;
                SUBSTR( lcTime, 3, 1 ) = ":"       .and. ;
                SUBSTR( lcTime, 6, 1 ) = ":"
                *
                *   03/27/00 -- parameters look just fine the way they are
                *
           case VarType( ldDate ) = "T"            .and. ;
                VarType( lcTime ) = "C"            .and. ;
                LEN( lcTime ) = 8                  .and. ;
                SUBSTR( lcTime, 3, 1 ) = ":"       .and. ;
                SUBSTR( lcTime, 6, 1 ) = ":"
                *
                *   Looks like user wants to override time of day in the DateTime() variable
                *
                ldDate = TTOD( ldDate ) && Date from DateTime() expression 
    
           case VarType( ldDate ) = "C"            .and. ;
                Len( ldDate ) = 8                  .and. ;
                ldDate = Str( val( ldDate ), 8 ) .and. ;
                VarType( lcTime ) = "C"            .and. ;
                LEN( lcTime ) = 8                  .and. ;
                SUBSTR( lcTime, 3, 1 ) = ":"       .and. ;
                SUBSTR( lcTime, 6, 1 ) = ":"                
                *
                *   03/27/00 -- allow passing DTOS() format date
                *
                ldDate = yyyymmdddt( ldDate )
                
           otherwise
                *
                *   Fill in bogus value with today's date...
                *
                ldDate = DATE()
                lcTime = TIME()
                   
        Endcase
      
   OTHERWISE
      *
      *   03/27/00 -- only 1 or 2 parameters allowed, anything else is an error, and defaults to current date and time
      *
      ldDate = DATE()
      lcTime = TIME()
      
ENDCASE
*
*
*
STORE padl( DAY( ldDate ), 2, spac(1) ) TO daydate && 04/22/99 -- padl( day() ) -- since set sysformats on
STORE SUBSTR(CDOW(ldDate),1,3) + ',' + ' ' + ;
   SUBSTR(CMONTH(ldDate),1,3) + ' ' + ;
   daydate + ',' + ' ' + ;
   STR(YEAR(ldDate),4) + ',' + ' ' TO datestring
hr_value = VAL(SUBSTR(lctime,1,2))
min_value = VAL(SUBSTR(lctime,4,2))
hr_result = 00
** IS IT 12 AM? **
*
IF hr_value = 00
   STORE '12' TO myhour
   STORE STR(min_value,2,0) TO myminute
   STORE 'am' TO am_pm
ENDIF ( hr_value = 00 )
** IS IT 12 PM? **
*
IF hr_value = 12
   STORE STR(hr_value,2,0) TO myhour
   STORE STR(min_value,2,0) TO myminute
   STORE 'pm' TO am_pm
ENDIF ( hr_value = 12 )
** IS IT 1 TO 9 AM? **
*
IF hr_value >= 1 .AND. hr_value <= 9
   STORE STR(hr_value,2,0) TO myhour
   STORE STR(min_value,2,0) TO myminute
   STORE 'am' TO am_pm
ENDIF ( hr_value >= 1 .AND. hr_value <= 9 )
** IS IT 10 OR 11 AM? **
*
IF hr_value = 10 .OR. hr_value = 11
   STORE STR(hr_value,2,0) TO myhour
   STORE STR(min_value,2,0) TO myminute
   STORE 'am' TO am_pm
ENDIF ( hr_value = 10 .OR. hr_value = 11 )
IF hr_value > 12
   hr_result = hr_value - 12
ENDIF ( hr_value > 12 )
*** IS IT 1 - 9 PM? **
*
IF hr_result >= 1 .AND. hr_result <= 9
   STORE STR(hr_result,2,0) TO myhour
   STORE STR(min_value,2,0) TO myminute
   STORE 'pm' TO am_pm
ENDIF ( hr_result >= 1 .AND. hr_result <= 9 )
** IS IT 10 OR 11 PM? **
*
IF hr_result = 10 .OR. hr_result = 11
   STORE STR(hr_result,2,0) TO myhour
   STORE STR(min_value,2,0) TO myminute
   STORE 'pm' TO am_pm
ENDIF ( hr_result = 10 .OR. hr_result = 11 )
IF myminute < '10'
   STORE '0' + SUBSTR(myminute,2,1) TO myminute
ENDIF ( myminute < '10' )
STORE ;
   myhour + ;
   ':' + ;
   myminute + ;
   ' ' + ;
   am_pm ;
   TO mytime && 05/14/98 -- almost forgot about 'Store' command

RETURN DateString + MyTime && leave datelinef() in DTM_PLIB.PRG
*------------------------------------------------------------------------------
*
*
     Function yyyymmdddt
*
*
*    06/16/94 -- Converts character string of form: YYYYMMDD to date format
*
*    07/24/97 -- it is up to the calling program to: 
*
*                               'SET CENTURY   ON / OFF'
*
*    01/04/99 -- Second parameter is default date to return if first 
*                parameter is not a valid character string
*
Lparameters   ; && 01/04/99 -- local parameters, not parameters...
   lcDate,    ; && 01/04/99 -- date in DTOS() format:  yyyymmdd
   lcDefault    && 06/17/99 -- default date if m.lcDate is invalid
 
assert PCount() = 1 .or. PCount() = 2 ;
       Message "YYYYMMDDT() expects 1 or 2 parameters, received " + alltrim( str( PCount() ) )

assert VarType( m.lcDate ) = "C" ;
       Message "YYYYMMDDT() first parameter must be type 'C', is type '" + VarType( m.lcDate ) + "'"
       
Local         ; && 01/04/99 -- local, not private
   lcString

do case

   case PCount() = 1 && 06/17/99 -- user only supplied the dtos() format date
   
      if VarType( m.lcDate ) <> "C" .or. ;
         empty( m.lcDate ) .or. ;
         LEN( alltrim( m.lcDate ) ) <> 8 .or. ;
         atc( "/", ; && 07/23/99 -- mm/dd/yy is bad format here
              m.lcDate, ;
              1 ) <> 0

         m.lcString = dtos( date() ) && 03/10/97 -- supply current date

      else
      
         m.lcString = m.lcDate 
      
      endif
      
   case PCount() = 2 
   
      if VarType( m.lcDate ) <> "C" .or. ;
         empty( m.lcDate ) .or. ;
         LEN( alltrim( m.lcDate ) ) <> 8 .or. ;
         atc( "/", ; && 07/23/99 -- mm/dd/yy is bad format here
              m.lcDate, ;
              1 ) <> 0
         *
         *   06/17/99 -- First parameter looks bad
         *               determine what to use as a default
         *
         if VarType( m.lcDefault ) = "C" .and. ;
            .not. empty( m.lcDefault ) .and.   ;
            len( alltrim( m.lcDefault ) ) = 8
            *
            *   01/04/99 -- handle user-supplied default return date
            *      
            m.lcString = m.lcDefault
   
         else
   
            m.lcString = dtos( date() ) && 3/10/97 -- supply current date
      
         endif

      else
         *
         *   06/17/99 -- first parameter looks good...
         *  
         m.lcString = m.lcDate 

      endif

   otherwise
      *
      *   06/17/99 -- looks like a complete mess in the parameter passing department
      *
      m.lcString = dtos( date() ) && 3/10/97 -- supply current date

endcase
*
*   Actually do the conversion on the return...
*
Return date( val( left(   m.lcString, 4 ) ), ; && leave YYYYMMDDDT() in DTM_PLIB.PRG
             val( SUBSTR( m.lcString, 5, 2 ) ), ;
             val( SUBSTR( m.lcString, 7, 2 ) ) )
*------------------------------------------------------------------------------
