*
*
*	Robin.prg -- set up Robin's favorites
*
*
LPARAMETERS ;
	lxWork	as	string,  ;
	lx2		as	variant, ;
	lx3		as	variant, ;
	lx4		as	variant, ;
	lx5		as	variant
*
*	06/07/2004 --- establish baseline development environment
*																		
WAIT clear
CLEAR TYPEAHEAD
CLOSE all
CLEAR DLLS 
CLEAR EVENTS 
CLEAR FIELDS 
CLEAR GETS 
CLEAR MACROS 
CLEAR MENUS 
CLEAR POPUPS	
CLEAR PROGRAM 
CLEAR PROMPT 
CLEAR READ ALL
CLEAR TYPEAHEAD 
CLEAR WINDOWS
CLEAR
ON KEY				&& eliminate nasty kestroke interpreter ( esp CTRL+Q )
SET status bar on	&& show the rows and columns in when editting
SET clock status	&& show the clock in the status bar
*
*	09/08/2003 -- restore VFP defaults after running Maxwin...
*
SET CENTURY			ON	&& mm/dd/yyyy not mm/dd/yy
SET CENTURY TO 19 ROLLOVER 80 && 12/19/2003 -- won't handle dates after 2080
SET CPDIALOG 		OFF && 02/08/2005
SET DELETED			ON  && 02/08/2005
SET EXACT			ON	
SET EXCLUSIVE 		OFF && 02/08/2005
SET MULTILOCKS		OFF	&& disallow 
SET PRINT			OFF && default when starting VFP 5
SET REPROCESS TO	0	&& failed locking retries
SET RESOURCE		ON	&& allow FOXUSER.DBF
SET SAFETY			ON	&& ask when erasing a file
SET sysmenu to 		default 
SET TALK			ON	&& jabber, jabber, jabber
SET TYPEAHEAD		TO  1024 && 07/26/2004 -- typehead may have up to 32,768 bytes in its buffer
*
*/RPC 09/09/2003 -- control printer font for VFP command window output 
*
SET printer font "Lucida Console",9 "B"

LOCAL	;
	lcCDrive, ;
	lcEMessage, ;
	lcSetDefaults, ;
	;
	llReturn

lcCDrive		=	SYS(5) && "C:\"
lcEMessage		=	""
lcSetDefaults	=	lcCDrive + PROPER( "util\Defaults.prg" )
llReturn		= 	.T.

*!*	DO	case

*!*		CASE 	PCOUNT() = 0
*!*		
*!*				lxWork	=	GETDIR( SYS(5)+SYS(2003),"Default dir" )
*!*				
*!*		CASE	PCOUNT() # 1 .or. ;
*!*				VARTYPE( lxWork ) # "C"
*!*		
*!*				lcEMessage	=	"Missing / Invalid parameter list passed" + ;
*!*								SPACE(5) + CHR(13) + ;
*!*								"Received " + ALLTRIM( STR( PCOUNT() ) ) + ;
*!*								" parameters, expects 1" + ;
*!*								SPACE(5) + CHR(13) + ;
*!*								IIF(PCOUNT() # 1, ;
*!*									"", ;
*!*									"Parameter should be type 'C', is type '" + ;
*!*									VARTYPE( lxWork ) + "'" )
*!*				llReturn	=	.F.
*!*		
*!*		OTHERWISE 

*!*			DO case 
*!*			
*!*				CASE	EMPTY( lxWork )
*!*					
*!*						lxWork	=	SYS(5) + SYS(2003)
*!*						
*!*				CASE 	DIRECTORY( lxWork )
*!*						*
*!*						*	nothing to do here, got what we like... 
*!*						*
*!*				OTHERWISE 
*!*				
*!*						llReturn = .F.
*!*						lcEMessage	=	"Parameter passed: '" + lxwork + "'" + ;
*!*										SPACE(5) + CHR(13) + ;
*!*										"is not a valid directory / folder name" + ;
*!*										SPACE(5) + CHR(13)
*!*			
*!*			ENDCASE 

*!*	ENDCASE 

IF	llReturn

	*/Robinc 03/26/2004 --- Remove window ("Properties")
	IF 	WEXIST( "Properties" )
		RELEASE window ( "Properties" )
	endif
	*/RobinC 04/10/2004 --- New class 'ErrorHandler'
	IF	TYPE( '_VFP.ErrorHandler' ) = "O"
		REMOVEPROPERTY( _vfp, "ERRORHANDLER" )
	ENDIF

	IF	"5." $ VERSION()
	ELSE
		loError = CREATEOBJECT(	"ERRORHANDLER" )
		ADDPROPERTY( _vfp, "ErrorHandler", loError )
		ON error =	_VFP.ERRORHANDLER.HANDLEERROR( 	Error(), ;
													Message(), ;
													Message(1), ;
													LineNo(), ;
													SYS(16) )
	ENDIF

*!*		IF FILE( lcSetDefaults )

*!*			KEYBOARD	CHR(13) + ;
*!*						"Note		Do " + lcSetDefaults + " with '" + ;
*!*						iif( type( 'lxwork' ) = "C", ;
*!*							lxwork,;
*!*							iif( type( 'lxwork' ) = "N", ;
*!*							alltrim( str( lxwork ) ), ;
*!*							"unknown value" ) ) + ;
*!*							"'" + ;
*!*							CHR(13) 
*!*			DO &lcSetDefaults with lxWork 

*!*		ELSE 

*!*			llReturn = .F.
*!*			lcEMessage =	"Unable to locate '" + lcSetDefaults + "'"

*!*		ENDIF 

	IF	llReturn 
		
		IF VARTYPE( _Screen ) = "O"

			with _Screen

				.Backcolor	=	RGB( 255, 255, 255 ) && WHITE
				.closable	=	.T.		
				.FontName	=	"Lucida Console"
				.FontBold	=	.T.
				.FontSize	=	10

				if file( "c:\robinfiles\graphics\ico\foxprow.ico" )
				
					.Icon = "c:\robinfiles\graphics\ico\foxprow.ico"
				
				endif

			endwith

		ELSE 

			llReturn = .F.
			lcEMessage = "Vartype( _Screen ) = '" + VARTYPE( _Screen ) + "'" + CHR(13) + ;
						"(Unable to set _screen fontname, fontsize, fontbold)"
					
		ENDIF
			
	ENDIF
	
ENDIF

IF VARTYPE( ocdonts ) # "O"
	ocdonts = CREATEOBJECT( "cdonts.newmail" )
ENDIF 

if	VARTYPE( oCDONTS ) # "O"
	llReturn = .F.
	=MESSAGEBOX( "Unable to CREATEOBJECT( 'CDONTS' )", ;
					48, ;
					PROGRAM( PROGRAM( -1 ) ) + " Error" )
ENDIF 

DO FORM CDONTSJUMPSTART NAME goCDONTSJUMPSTART LINKED 

READ EVENTS && CDONTSJUMPSTART is Modeless

IF 	.not. llReturn .and. ;
	.not. EMPTY( lcEMessage )
	
	=MESSAGEBOX(	lcEMessage, ;
					16, ;
					"Program terminated by error" )
	lcEMessage = ""
					
ENDIF 

RETURN llReturn && leave ROBIN.PRG
*------------------------------------------------------------------------------
*
*
	FUNCTION	LongFileName(	lcFileName, ;
								lx2, ;
								lx3,; 
								lx4, ;
								lx5, ;
								lx6 )
*
*	Handle those pesky embedded blanks
*
LOCAL	;
	lcReturn
	
lcReturn = "" && empty string	

IF	PCOUNT() = 1 .and.; 
	TYPE( 'lcFileName' ) = "C" .and. ;
	.not. EMPTY( lcFileName )
	
	IF	ATC(	SPACE(1), lcFileName, 1 )	=	0
		lcReturn = lcFileName
	ELSE
		IF	ATC(	'"', lcFileName, 1 ) = 0
			lcReturn = '"' + lcFileName + '"'
		ELSE
			lcReturn = "'" + lcFileName + "'"
		ENDIF
	ENDIF
	
ENDIF	
	
RETURN lcReturn && leave LongFileName() in Robin.prg	
*------------------------------------------------------------------------------
*
*
	Define Class ErrorHandler As Custom
*
*
*
*------------------------------------------------------------------------------
*
*
	Function Init()
	ENDFUNC	
*------------------------------------------------------------------------------
*
*
	Function HandleError(	lnError, ;
							lcMessage, ;
							lcMessage1, ;
							lnLineNo, ;
							lcCaption, ;
							lx6, ;
							lx7, ;
							lx8, ;
							lx9 )
	*
	*
	*	Handle program errors for TESTFICA
	*
	*	
	LOCAL	;
		lcProgram, ;
		lcString, ;
		;
		lnForNext, ;
		;
		llReturn
		
	llReturn = .T.
	*/RobinC 03/24/2004 --- Don't report any errors on Line # 0 ( VFP internal errors )
*!*		IF	TYPE( 'lnLineNo' ) = "N" .and. ;
*!*			( lnLineNo # 0 .or. .not. WEXIST( "project manager" ) )
			
			
		=MESSAGEBOX(	"Vartype( lcMessage1 ) = '" + ;
						VARTYPE( lcMessage1 ) + ;
						"'" + SPACE(5) + CHR(13) + ;
						IIF(VARTYPE(lcMessage1)="C", ;
							lcMessage1, ;
							"Cannot display lcmessage1"), ;
						48, ;
						PROGRAM( PROGRAM( -1 ) ) + ;
						" DEBUG" )
						
		IF	UPPER( ALLTRIM( lcMessage1 ) ) = CHR(38) + "LCCOMMAND" .and. ;
			TYPE( 'lcCommand' ) = "C"

			lcMessage1 =	lcMessage1 + CHR(13) + ;
							"lcCommand = '" + lcCommand + "'"

		ENDIF
			
		lcString = 	lcMessage + ;
					" ( " + alltrim( str( lnError ) ) ;
					+ " ) " + chr(13) + ;
					iif(.not.EMPTY(lcMessage1).and.lcMessage # lcMessage1, ;
						lcMessage1 + chr(13), ;
						"" ) + ;
					"Line # " + alltrim( str( lnLineNo ) ) + chr(13) + chr(13) + ;
					"Calling stack:" 


		FOR lnForNext = 255 to 1 STEP -1

			lcProgram = Program( lnForNext )

			if	.not. EMPTY( lcProgram )	;
				.and.						;
				.not. INLIST(	lcProgram,	;
								"ERRORHANDLER.HANDLEERROR", ;
								"ON...",	;
								"ERRORRTN" )
			
				lcString	=	lcString + ;
								chr(13) + space(5) + lcProgram
								
			ENDIF

		NEXT lnForNext
					
		IF	6	#	MessageBox(	lcString + chr(13) + chr(13) + ;
								"Continue running program?", ;
								4 + ; && [Yes] [No]
								48, ; && ! exclamation point icon
								IIF(TYPE( 'lcCaption' ) = "C" .and. .not. empty( lcCaption ), ;
									lcCaption, ;
									"_VFP.ErrorHandler.HandleError()" )	)
			
			CANCEL && should this be QUIT ?
													
		ENDIF

		IF VARTYPE( ocdonts ) # "O"
			ocdonts = CREATEOBJECT( "cdonts.newmail" )
		ENDIF 

		IF VARTYPE( ocdonts ) = "O"
			
			ocdonts.To		=	"RPConnelly@earthlink.net"
			ocdonts.From	=	"Admin@user.com"
			ocdonts.Subject =	"!! Software Error !!"
			ocdonts.Body	=	CHR(13) + "Machine # User ID = " + SYS(0) + ;
								CHR(13) + CHR(13) + lcString
			oCDONTS.Send()
		    RELEASE oCDONTS

		ELSE 
				=MESSAGEBOX( "'oCDONTS' is not an object", ;
								48, ;
								PROGRAM( PROGRAM( -1 ) ) + " Failed" )
		ENDIF 
						
*!*		ENDIF
													
	ENDFUNC && leave HANDLEERROR() in ROBIN.prg

Enddefine && leave  Class ERRORHANDLER As Custom
*------------------------------------------------------------------------------
*
*
	FUNCTION GarbageCode(	lx1, ;
							lx2, ;
							lx3, ;
							lx4, ;
							lx5 ) 

lcMessage	= 	"Error number: " + ALLTRIM( STR( nError ) ) + ;
				SPACE(5) + CHR(13) + ;
				"Line # " + ALLTRIM( STR( nLine ) ) + ;
				" in " + cMethod + ;
				SPACE(5) + CHR(13)
				
=MESSAGEBOX(	lcMessage, ;
				48, ;
				PROGRAM( PROGRAM( -1 ) ) + " Error Event" )

IF VARTYPE( ocdonts ) = "O"
	
	ocdonts.To="RPConnelly@earthlink.net"
	ocdonts.From="Admin@user.com"
	ocdonts.Subject
	ocdonts.Subject = "!! Software Error !!"
	ocdonts.Body= CHR(13) + "Machine # User ID = " + SYS(0) + CHR(13) + CHR(13) + lcMessage

ELSE 
		=MESSAGEBOX( "'oCDONTS' is not an object", ;
						48, ;
						PROGRAM( PROGRAM( -1 ) ) + " Failed" )
ENDIF 
	
PUBLIC ;
	oCDONTS as Object 
	
IF VARTYPE( ocdonts ) # "O"
	ocdonts = CREATEOBJECT( "cdonts.newmail" )
ENDIF 

if	VARTYPE( oCDONTS ) # "O"
	llReturn = .F.
	=MESSAGEBOX( "Unable to CREATEOBJECT( 'CDONTS' )", ;
					48, ;
					PROGRAM( PROGRAM( -1 ) ) + " Error" )
ENDIF 

IF 	VARTYPE( thisform.cerror ) = "C" .and. ;
	.not. EMPTY( thisform.cerror ) 

	lcString = thisform.cError
	ON ERROR &lcString
	
ENDIF 

RETURN .T. && leave GarbageCode() in Robin.prg